<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class UpdateParagraphStyleRequest extends \Google\Model
{
  /**
   * The fields that should be updated. At least one field must be specified.
   * The root `paragraph_style` is implied and should not be specified. A single
   * `"*"` can be used as short-hand for listing every field. For example, to
   * update the paragraph style's alignment property, set `fields` to
   * `"alignment"`. To reset a property to its default value, include its field
   * name in the field mask but leave the field itself unset.
   *
   * @var string
   */
  public $fields;
  protected $paragraphStyleType = ParagraphStyle::class;
  protected $paragraphStyleDataType = '';
  protected $rangeType = Range::class;
  protected $rangeDataType = '';

  /**
   * The fields that should be updated. At least one field must be specified.
   * The root `paragraph_style` is implied and should not be specified. A single
   * `"*"` can be used as short-hand for listing every field. For example, to
   * update the paragraph style's alignment property, set `fields` to
   * `"alignment"`. To reset a property to its default value, include its field
   * name in the field mask but leave the field itself unset.
   *
   * @param string $fields
   */
  public function setFields($fields)
  {
    $this->fields = $fields;
  }
  /**
   * @return string
   */
  public function getFields()
  {
    return $this->fields;
  }
  /**
   * The styles to set on the paragraphs. Certain paragraph style changes may
   * cause other changes in order to mirror the behavior of the Docs editor. See
   * the documentation of ParagraphStyle for more information.
   *
   * @param ParagraphStyle $paragraphStyle
   */
  public function setParagraphStyle(ParagraphStyle $paragraphStyle)
  {
    $this->paragraphStyle = $paragraphStyle;
  }
  /**
   * @return ParagraphStyle
   */
  public function getParagraphStyle()
  {
    return $this->paragraphStyle;
  }
  /**
   * The range overlapping the paragraphs to style.
   *
   * @param Range $range
   */
  public function setRange(Range $range)
  {
    $this->range = $range;
  }
  /**
   * @return Range
   */
  public function getRange()
  {
    return $this->range;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UpdateParagraphStyleRequest::class, 'Google_Service_Docs_UpdateParagraphStyleRequest');
