<table class="table table-striped">
    <thead>
    <tr>
        <th>Job ID</th>
        <th>Category</th>
        <th>Date Published</th>
        <th>Expiring In</th>
        <th>Expiry Date</th>
        <th>Status</th>
     
    </tr>
    </thead>
    <tbody>

<?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr style="cursor:pointer;"
        onclick="openactiveadDetailsCanvaso(<?php echo e(json_encode($job)); ?>)">
        <td><?php echo e($job->id); ?></td>
        <td><?php echo e($job->category); ?></td>
        <td><?php echo e($job->created_at->format('d M Y')); ?></td>
        <td><?php echo e(round(abs(\Carbon\Carbon::parse($job->expiry_date)->diffInDays($job->created_at, false)))); ?> days</td>
        <td><?php echo e($job->expiry_date); ?></td>
        <td>
            <?php switch($job->status):
                case ('active'): ?>
                    <span class="badge bg-primary">Active</span>
                    <?php break; ?>

                <?php case ('open'): ?>
                    <span class="badge bg-success">Open</span>
                    <?php break; ?>

                <?php case ('expired'): ?>
                    <span class="badge bg-danger">Expired</span>
                    <?php break; ?>

                <?php case ('closed'): ?>
                    <span class="badge bg-secondary">Closed</span>
                    <?php break; ?>

                <?php default: ?>
                    <span class="badge bg-dark"><?php echo e(ucfirst($job->status)); ?></span>
            <?php endswitch; ?>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>
</table>


 
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="openadDetailsCanvaso">
    <div class="offcanvas-header bg-gradient-primary text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-info-circle me-2"></i> Ad Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">

        <div class="row mb-3 align-items-center justify-content-between">
    <!-- Left side: Title -->
    <div class="col-auto">
        <h6 class="fw-bold text-primary mb-0">
            <i class="fa fa-list me-2"></i> Job Ad Information
        </h6>
    </div>

    <!-- Right side: Expiry Button -->
    <div class="col-auto">
        <button class="btn btn-outline-danger btn-sm fw-semibold">
            Expiring in: <span id="days_left_dispalyo">30</span> Days
        </button>
    </div>
</div>


        <div>
            <hr>
        </div>

        <div>
            <row class="mb-4">
                <div class="col">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="offcanvas">
                        <i class="fa fa-arrow-left me-2"></i> Back to Job Listings
                    </button>
                    <!-- edito Job Ad Button -->
<button type="button" 
        class="btn btn-primary btn-sm ms-2" 
        onclick="editAdFormo();">
    <i class="fa fa-edito me-2"></i> Edit Job Ad
</button>




<!-- Delete button -->
<button id="deleteBtn" type="button" class="btn btn-danger btn-sm ms-2" onclick="deleteAd()">
  <i class="fa fa-trash me-2"></i> Delete Job Ad
</button>

                    
    <!-- Close Job Ad button -->
<button id="closeBtn" type="button" class="btn btn-warning btn-sm ms-2" onclick="closeAd()">
  <i class="fa fa-times me-2"></i> Close Job Ad
</button>

                    
                    
                </div>
            </row>
        </div>

        <br>

        <div class="row g-4">
            <!-- Ad Type -->
<div class="col-md-12">
    <div class="card" 
         style="border: none; border-radius: 16px; 
                background: linear-gradient(135deg, #f0f8ff, #e6f7ff); 
                box-shadow: 0 8px 20px rgba(0,0,0,0.15); 
                transition: all 0.4s ease; overflow: hidden;">
        <div class="card-body d-flex align-items-center justify-content-between" 
             style="dispalyo: flex; align-items: center; justify-content: space-between; padding: 20px;">
            
            <!-- Left side: Icon + Title -->
            <div style="dispalyo: flex; align-items: center; gap: 14px;">
                
                <div>
                    <h5 style="margin: 0; font-weight: 700; 
                               background: linear-gradient(90deg, #007bff, #00c6ff); 
                               -webkit-background-clip: text; 
                               -webkit-text-fill-color: transparent;">
                        Ad Type
                    </h5>
                    <p id="ad_type_dispalyo" 
                       style="margin: 0; font-size: 1.1rem; font-weight: 600; color: #333;">
                        Basic
                    </p>
                </div>
            </div>

            <!-- Right side: Status badge -->
            <span id="ad_status-displayo" style="background: linear-gradient(90deg, #36c95f, #2f8f4e); 
                         color: #fff; font-weight: 600; 
                         padding: 8px 16px; border-radius: 20px; 
                         box-shadow: 0 4px 12px rgba(47,143,78,0.4); 
                         font-size: 0.9rem; letter-spacing: 0.5px;">
                Status
            </span>
        </div>
    </div>
</div>



            <!-- Job Title -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Title</h5>
                        <p class="card-text" id="job_title_dispalyo">Software Engineer</p>
                    </div>
                </div>
            </div>

            <!-- Company -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Company</h5>
                        <p class="card-text" id="company_dispalyo">Tech Solutions Inc.</p>
                    </div>
                </div>
            </div>

            <!-- Category -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Category</h5>
                        <p class="card-text" id="category_dispalyo">Information Technology</p>
                    </div>
                </div>
            </div>

            <!-- Location -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Location</h5>
                        <p class="card-text" id="location_dispalyo">New York, NY</p>
                    </div>
                </div>
            </div>

            <!-- Workplace -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Workplace</h5>
                        <p class="card-text" id="workplace_dispalyo">Remote</p>
                    </div>
                </div>
            </div>

            <!-- Type of Work -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Type of Work</h5>
                        <p class="card-text" id="work_type_dispalyo">Full-time</p>
                    </div>
                </div>
            </div>

            <!-- Pay Type -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Type</h5>
                        <p class="card-text" id="pay_type_dispalyo">Hourly</p>
                    </div>
                </div>
            </div>

            <!-- Pay Min -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Min</h5>
                        <p class="card-text" id="pay_min_dispalyo">$25</p>
                    </div>
                </div>
            </div>

            <!-- Pay Max -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Max</h5>
                        <p class="card-text" id="pay_max_dispalyo">$40</p>
                    </div>
                </div>
            </div>

            <!-- Pay Visibility -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Visibility</h5>
                        <p class="card-text" id="pay_visibility_dispalyo">Visible</p>
                    </div>
                </div>
            </div>

            <!-- Job Description -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Description</h5>
                        <div id="description_dispalyo"></div>
                        
                    </div>
                </div>
            </div>

            <!-- Job Summary -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Summary</h5>
                     <div id="summary_dispalyo"></div>
                        
                    </div>
                </div>
            </div>

        <!-- Logo -->
<div class="col-md-6" id="logo_field_dispalyo">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <h5 class="card-title">Logo</h5>
            <img id="logo_dispalyo" src="" alt="Company Logo" 
                 style="max-width: 150px; height: auto; border-radius: 8px;">
        </div>
    </div>
</div>

<!-- Overview -->
<div class="col-md-6" id="overview_field_dispalyo">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Overview</h5>
            <p class="card-text" id="overview_dispalyo"></p>
        </div>
    </div>
</div>

<!-- Social Media -->
<div class="col-md-6" id="social_media_field_dispalyo">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Social Media</h5>
            <p class="card-text" id="social_media_dispalyo"></p>
        </div>
    </div>
</div>

<!-- Video -->
<div class="col-md-6" id="video_field_dispalyo">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Video</h5>
            <a id="video_dispalyo" href="#" target="_blank">Watch Video</a>
        </div>
    </div>
</div>


            <!-- Questions -->
     <div class="col-md-12">
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title">Questions to Candidates</h5>
      <div id="questionsWrappero" class="row">
        <!-- Questions will be injected here -->
      </div>
    </div>
  </div>
</div>

        </div>

        <!-- Close Button -->
        <div class="mt-4 text-end">
            <button type="button" class="btn btn-danger" data-bs-dismiss="offcanvas">Close</button>
        </div>
    </div>
</div>


<!-- edito Job Ad Offcanvas -->
<div class="offcanvas offcanvas-top" tabindex="-1" id="editAdCanvaso" aria-labelledby="editAdCanvasLabel"
     style="height: 100vh; background: linear-gradient(135deg, white); border-radius: 0 0 20px 20px; box-shadow: 0 8px 30px rgba(0,0,0,0.2);">
  <div class="offcanvas-header border-bottom" style="background: rgb(113,16,62); color: #fff;">
    <h5 class="offcanvas-title fw-bold" id="editoAdCanvasLabel">
      <i class="fa fa-edito me-2"></i> edito Job Ad
    </h5>
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <form id="editoAdForm" class="row g-3">
      
      <!-- Job Title -->
   <div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-briefcase me-2 text-primary"></i> Job Title
  </label>
  <div class="p-3 bg-light border-start border-4 border-primary rounded shadow-sm fw-bold text-dark" 
       id="edito_job_title"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-building me-2 text-primary"></i> Company
  </label>
  <div class="p-3 bg-light border-start border-4 border-success rounded shadow-sm fw-bold text-dark" 
       id="edito_company"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-tags me-2 text-primary"></i> Category
  </label>
  <div class="p-3 bg-light border-start border-4 border-warning rounded shadow-sm fw-bold text-dark" 
       id="edito_category"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-map-marker-alt me-2 text-primary"></i> Location
  </label>
  <div class="p-3 bg-light border-start border-4 border-danger rounded shadow-sm fw-bold text-dark" 
       id="edito_location"></div>
</div>

<div class="col-12">
        <h6 class="fw-bold text-primary mb-4">
          <i class="fa fa-info-circle me-2"></i> You can edito the job ad details below
        </h6>
        </div>

      <!-- Workplace -->
   <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-laptop-house me-2 text-primary"></i> Workplace
  </label>
  <select class="form-select shadow-sm" id="edito_workplace">
    <option value="">Select Workplace</option>
    <option value="On-site">On-site</option>
    <option value="Remote">Remote</option>
    <option value="Hybrid">Hybrid</option>
  </select>
</div>


      <!-- Work Type -->
     <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-clock me-2 text-primary"></i> Work Type
  </label>
  <select class="form-select shadow-sm" id="edito_work_type">
    <option value="">Select Work Type</option>
    <option value="Full-time">Full-time</option>
    <option value="Part-time">Part-time</option>
    <option value="Casual">Casual</option>
    <option value="Contract">Contract</option>
    <option value="Internship">Internship</option>
    <option value="Temporary">Temporary</option>
  </select>
</div>


      <!-- Pay Type -->
      <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-money-bill me-2 text-primary"></i> Pay Type
  </label>
  <select class="form-select shadow-sm" id="edito_pay_type">
    <option value="">Select Pay Type</option>
    <option value="Hourly">Hourly</option>
    <option value="Salary">Salary</option>
    <option value="Contract">Contract</option>
    <option value="Commission">Commission</option>
  </select>
</div>


      <!-- Pay Range -->
      <div class="col-md-3">
        <label class="form-label fw-semibold">Min Pay</label>
        <input type="number" class="form-control shadow-sm" id="edito_pay_min">
      </div>
      <div class="col-md-3">
        <label class="form-label fw-semibold">Max Pay</label>
        <input type="number" class="form-control shadow-sm" id="edito_pay_max">
      </div>

      <!-- Description -->
<div class="col-12">
  <label class="form-label fw-semibold">
    <i class="fa fa-align-left me-2 text-primary"></i> Description
  </label>
  <textarea class="form-control shadow-sm" id="edito_description" rows="6"></textarea>
</div>

<!-- Summary -->
<div class="col-12">
  <label class="form-label fw-semibold">
    <i class="fa fa-sticky-note me-2 text-primary"></i> Summary
  </label>
  <textarea class="form-control shadow-sm" id="edito_summary" rows="4"></textarea>
</div>

        <!-- Overview -->   
        <div class="col-12" id="overview_field_edito">
        <label class="form-label fw-semibold"><i class="fa fa-info
-circle me-2 text-primary"></i> Overview</label>
        <textarea class="form-control shadow-sm" id="edito_overview" rows="4"></textarea>
        </div>



      <!-- Logo -->
      <div class="col-md-6" id="logo_field_edito">
        <label class="form-label fw-semibold"><i class="fa fa-image me-2 text-primary"></i> Logo</label>
        <input type="text" class="form-control shadow-sm" id="edito_logo" placeholder="Logo URL">
      </div>

      <!-- Social Media -->
      <div class="col-md-6 " id="social_media_field_edito">
        <label class="form-label fw-semibold"><i class="fa fa-share-alt me-2 text-primary"></i> Social Media</label>
        <input type="text" class="form-control shadow-sm" id="edito_social_media">
      </div>

      <!-- Video -->
      <div class="col-md-6" id="video_field_edito">
        <label class="form-label fw-semibold"><i class="fa fa-video me-2 text-primary"></i> Video</label>
        <input type="text" class="form-control shadow-sm" id="edito_video" placeholder="Video URL">
      </div>
     

      <!-- Save Button -->
      <div class="col-12 text-end mt-4">
<button id="saveBtn" type="button" class="btn btn-outline-success px-4 shadow-sm" onclick="saveAdChanges()">
  <i class="fa fa-save me-2"></i> Save Changes
</button>

      </div>
    </form>
  </div>
</div>


<script>

function openactiveadDetailsCanvaso(ad) {
    console.log(ad);

    sessionStorage.setItem('selectedAd', JSON.stringify(ad));

    console.log("Ad data saved to sessionStorage.", ad);    



    // Populate the fields with the ad details
    document.getElementById('ad_status-displayo').innerText = ad.status || 'N/A';
    document.getElementById('ad_type_dispalyo').innerText = ad.ad_type || 'N/A';
    document.getElementById('job_title_dispalyo').innerText = ad.job_title || 'N/A';
    document.getElementById('company_dispalyo').innerText = ad.company || 'N/A';
    document.getElementById('category_dispalyo').innerText = ad.category || 'N/A';
    document.getElementById('location_dispalyo').innerText = ad.location || 'N/A';
    document.getElementById('workplace_dispalyo').innerText = ad.workplace || 'N/A';
    document.getElementById('work_type_dispalyo').innerText = ad.work_type || 'N/A';
    document.getElementById('pay_type_dispalyo').innerText = ad.pay_type || 'N/A';
    document.getElementById('pay_min_dispalyo').innerText = ad.pay_min !== undefined ? `$${ad.pay_min}` : 'N/A';
    document.getElementById('pay_max_dispalyo').innerText = ad.pay_max !== undefined ? `$${ad.pay_max}` : 'N/A';
    document.getElementById('pay_visibility_dispalyo').innerText = ad.pay_visibility || 'N/A';
    document.getElementById('description_dispalyo').innerHTML = ad.description_html || 'N/A';
    document.getElementById('summary_dispalyo').innerHTML = ad.summary_html || 'N/A';
  

    // --- Conditional dispalyo based on ad_type ---
    const logoField = document.getElementById('logo_field_dispalyo');
    const overviewField = document.getElementById('overview_field_dispalyo');
    const socialField = document.getElementById('social_media_field_dispalyo');
    const videoField = document.getElementById('video_field_dispalyo');
 

    // Hide all by default
    logoField.style.dispalyo = 'none';
    overviewField.style.dispalyo = 'none';
    socialField.style.dispalyo = 'none';
    videoField.style.dispalyo = 'none';

    if (ad.ad_type === "basic") {
        // Show only overview + social
        // overviewField.style.dispalyo = 'block';
        // socialField.style.dispalyo = 'block';
    } else if (ad.ad_type === "premium") {
        // Show logo, overview, social (hide video)
        logoField.style.dispalyo = 'block';
        overviewField.style.dispalyo = 'block';
        socialField.style.dispalyo = 'block';
    } else if (ad.ad_type === "platinum") {
        // Show everything
        logoField.style.dispalyo = 'block';
        overviewField.style.dispalyo = 'block';
        socialField.style.dispalyo = 'block';
        videoField.style.dispalyo = 'block';
    }

    // --- Populate values ---
    // Logo (image)
    if (ad.logo) {
        const logoImg = document.getElementById('logo_dispalyo');
        logoImg.src = ad.logo;
        logoImg.alt = ad.company || "Company Logo";
    }

    // Overview
    if (ad.overview) {
        document.getElementById('overview_dispalyo').innerText = ad.overview;
    }

    // Social Media
    if (ad.social_media) {
        document.getElementById('social_media_dispalyo').innerText = ad.social_media;
    }

    // Video
    if (ad.video) {
        document.getElementById('video_dispalyo').href = ad.video;
        document.getElementById('video_dispalyo').innerText = "Watch Video";
    }

    // --- Days left until expiry ---
    const today = new Date();
    const expiryDate = new Date(ad.expiry_date);
    const timeDiff = expiryDate - today;
    const daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));
    document.getElementById('days_left_dispalyo').innerText = daysLeft > 0 ? daysLeft : '0';

    // --- Populate Questions ---// --- Populate questions ---
const questionsWrapper = document.getElementById('questionsWrappero');
questionsWrapper.innerHTML = ''; // Clear previous questions

const questions = ad.questions || [];

// Split into two roughly equal halves
const half = Math.ceil(questions.length / 2);
const col1 = questions.slice(0, half);
const col2 = questions.slice(half);

// Create column containers
const col1Div = document.createElement('div');
col1Div.className = 'col-md-6';
const col2Div = document.createElement('div');
col2Div.className = 'col-md-6';

// Add questions with ticks
col1.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col1Div.appendChild(p);
});

col2.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col2Div.appendChild(p);
});

// Append both columns to wrapper
questionsWrapper.appendChild(col1Div);
questionsWrapper.appendChild(col2Div);



    // --- Show the ad details canvas ---
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('openadDetailsCanvaso'));
    offcanvas.show();
}

function closeOtherOffcanvas() {
    // Close Ad Details offcanvas if open
    const openadDetailsCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('openadDetailsCanvaso'));
      if (openadDetailsCanvas) openadDetailsCanvas.hide();

    // Close Active Jobs offcanvas if open
    const jobOffcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('jobOffcanvas-active'));
  
    if (jobOffcanvas) jobOffcanvas.hide();
}




function editAdFormo(ad = null) {

    console.log("Opening edito Ad Form...", ad);
    // closeOtherOffcanvas();

    if (!ad) {
        const adData = sessionStorage.getItem('selectedAd');
        ad = adData ? JSON.parse(adData) : null;
    }
    if (!ad) return;

    // Populate fields
    //     // Populate read-only dispalyo fields
    document.getElementById('edito_job_title').textContent = ad.job_title   ?? '';
    document.getElementById('edito_company').textContent   = ad.company     ?? '';
    document.getElementById('edito_category').textContent  = ad.category    ?? '';
    document.getElementById('edito_location').textContent  = ad.location    ?? '';
    //     // Populate editoable fields
    document.getElementById('edito_workplace').value    = ad.workplace   ?? '';
    document.getElementById('edito_work_type').value    = ad.work_type   ?? '';
    document.getElementById('edito_pay_type').value     = ad.pay_type    ?? '';
    document.getElementById('edito_pay_min').value      = ad.pay_min     ?? '';
    document.getElementById('edito_pay_max').value      = ad.pay_max     ?? '';
    document.getElementById('edito_description').value  = ad.description ?? '';
    document.getElementById('edito_overview').value      = ad.overview     ?? '';
    document.getElementById('edito_summary').value      = ad.summary     ?? '';
    document.getElementById('edito_logo').value          = ad.logo         ?? '';
    document.getElementById('edito_social_media').value  = ad.social_media ?? '';
    document.getElementById('edito_video').value         = ad.video        ?? '';

    // Grab wrapper divs
    const logoFieldedito     = document.getElementById('logo_field_edito');
    const overviewFieldedito = document.getElementById('overview_field_edito');
    const socialFieldedito   = document.getElementById('social_media_field_edito');
    const videoFieldedito    = document.getElementById('video_field_edito');

    // Hide all by default
    [logoFieldedito, overviewFieldedito, socialFieldedito, videoFieldedito].forEach(el => el.style.dispalyo = 'none');

    // Show depending on ad_type
    if (ad.ad_type === "basic") {
        // overviewFieldedito.style.dispalyo = 'block';
        // socialFieldedito.style.dispalyo   = 'block';
    } else if (ad.ad_type === "premium") {
        logoFieldedito.style.dispalyo     = 'block';
        overviewFieldedito.style.dispalyo = 'block';
        socialFieldedito.style.dispalyo   = 'block';
    } else if (ad.ad_type === "platinum") {
        logoFieldedito.style.dispalyo     = 'block';
        overviewFieldedito.style.dispalyo = 'block';
        socialFieldedito.style.dispalyo   = 'block';
        videoFieldedito.style.dispalyo    = 'block';
    }

    // Show offcanvas
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('editAdCanvaso'));
    offcanvas.show();
}





// Function to collect updated data
function saveAdChanges() {
    const saveBtn = document.getElementById('saveBtn');

    // Disable button and show circle spinner inside it
    saveBtn.disabled = true;
    saveBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span> Saving Changes...';

    // Retrieve the selected ad
    const adData = sessionStorage.getItem('selectedAd');
    const originalAd = adData ? JSON.parse(adData) : {};

    const updatedAd = {
        id:            originalAd.id,
        workplace:     document.getElementById('edito_workplace').value.trim(),
        work_type:     document.getElementById('edito_work_type').value.trim(),
        pay_type:      document.getElementById('edito_pay_type').value.trim(),
        pay_min:       parseFloat(document.getElementById('edito_pay_min').value) || null,
        pay_max:       parseFloat(document.getElementById('edito_pay_max').value) || null,
        description:   document.getElementById('edito_description').value.trim(),
        summary:       document.getElementById('edito_summary').value.trim(),
        logo:          document.getElementById('edito_logo').value.trim(),
        social_media:  document.getElementById('edito_social_media').value.trim(),
        video:         document.getElementById('edito_video').value.trim(),
        overview:      document.getElementById('edito_overview').value.trim()
    };

    fetch(`/jobboards/${updatedAd.id}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(updatedAd)
    })
    .then(res => {
        if (!res.ok) throw new Error(`Server error: ${res.status}`);
        return res.json();
    })
    .then(data => {
        Notiflix.Notify.success('Job updated successfully!');
        sessionStorage.setItem('selectedAd', JSON.stringify(updatedAd));

        // Close offcanvas and redirect
        const offcanvasEl = document.getElementById('editoAdCanvas');
        const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
        if (offcanvas) offcanvas.hide();
        window.location.href = '/admin/home';
    })
    .catch(err => {
        Notiflix.Notify.failure(`Update failed: ${err.message}`);
    })
    .finally(() => {
        // Restore button state
        saveBtn.disabled = false;
        saveBtn.innerHTML = '<i class="fa fa-save me-2"></i> Save Changes';
    });
}

// Function to delete the selected ad
function deleteAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to delete.');
        return;
    }

    // Fancy Confirm dialog
    Notiflix.Confirm.show(
        // Title with FA icon
        '<i class="fa fa-exclamation-triangle text-danger me-2"></i> <span style="color:#dc3545;font-weight:bold;">Confirm Delete</span>',
        
        // Message with styled text
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#dc3545;">delete</b> this job ad?</span>',
        
        // OK button text with FA icon
        '<i class="fa fa-trash me-2"></i> Yes, Delete',
        
        // Cancel button text with FA icon
        '<i class="fa fa-times me-2"></i> Cancel',
        
        function okCb() {
            // Configure loader appearance
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px',
                cssAnimationDuration: 4000
            });

            // Show dotted circle loader
            Notiflix.Loading.circle('Deleting job ad...');

            const start = Date.now();
            const minDuration = 3000; // 3 seconds minimum

            fetch(`/jobboards/${ad.id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);
                return res.json();
            })
            .then(data => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.init({
                        timeout: 3000,
                        clickToClose: true,
                        pauseOnHover: true
                    });
                    Notiflix.Notify.success('Job ad deleted successfully!');
                    sessionStorage.removeItem('selectedAd');
                    window.location.href = '/admin/home';
                }, remaining);
            })
            .catch(err => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.failure(`Delete failed: ${err.message}`);
                }, remaining);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Delete cancelled.');
        },
        {
            // Extra styling for buttons
            okButtonBackground: '#dc3545',   // red delete button
            okButtonColor: '#fff',
            cancelButtonBackground: '#6c757d', // grey cancel button
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}


// Function to close other offcanvas elements
function closeAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to close.');
        return;
    }

    // Fancy confirm dialog
    Notiflix.Confirm.show(
        '<i class="fa fa-exclamation-circle text-warning me-2"></i> <span style="color:#ffc107;font-weight:bold;">Confirm Close</span>',
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#ffc107;">close</b> this job ad?</span>',
        '<i class="fa fa-check me-2"></i> Yes, Close',
        '<i class="fa fa-times me-2"></i> Cancel',
        function okCb() {
            // Show loader
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px'
            });
            Notiflix.Loading.circle('Closing job ad...');

            fetch(`/jobboards/${ad.id}/close`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);  
                return res.json();
            })
            .then(data => {
                Notiflix.Loading.remove();
                Notiflix.Notify.init({
                    timeout: 3000,
                    clickToClose: true,
                    pauseOnHover: true
                });
                Notiflix.Notify.success('Job ad closed successfully!');
                // Optionally redirect
                window.location.href = '/admin/home';
            })
            .catch(err => {
                Notiflix.Loading.remove();
                Notiflix.Notify.failure(`Close failed: ${err.message}`);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Close cancelled.');
        },
        {
            okButtonBackground: '#ffc107',   // yellow close button
            okButtonColor: '#000',
            cancelButtonBackground: '#6c757d',
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}
</script>
<?php /**PATH E:\CareerJobs\resources\views\components\openjobs.blade.php ENDPATH**/ ?>