<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'CareerJobs')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
       <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    


    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>
<body >
    <div id="app">
    <nav id="navbar">
    <div class="nav-container">
        <a href="#home" class="logo">
            <img src="/assets/images/logo.png" alt="Logo Icon" height="40px" width="40px">
            <span class="logo-text">CareerJobs</span>
        </a>

        <ul class="nav-links">
            <li><a href="#dashboard">Dashboard</a></li>
            <li><a href="#analytics">Analytics</a></li>
            <li><a href="#reports">Reports</a></li>
            <li><a href="#contact">Contact</a></li>

            
            
            <li><a href="<?php echo e(url('/chat')); ?>">Online Chat Support</a></li>
            <li><a href="<?php echo e(url('/faqs')); ?>">FAQs</a></li>

            
            <?php if(auth()->guard()->guest()): ?>
                <?php if(Route::has('login')): ?>
                    <li><a href="<?php echo e(route('login')); ?>">Login</a></li>
                <?php endif; ?>

                <?php if(Route::has('register')): ?>
                    <li><a href="<?php echo e(route('register')); ?>">Register</a></li>
                <?php endif; ?>
            <?php else: ?>
        <li class="dropdown">
    <a id="navbarDropdown" class="dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
        <?php echo e(Auth::user()->name); ?>

    </a>

    <div class="dropdown-menu dropdown-menu-end" 
         style="background-color: rgb(113,16,62) !important;">
        <a class="dropdown-item logout-item" 
           href="<?php echo e(route('logout')); ?>"
           onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
           style="color: white;">
            My Profile
        </a>

        <a class="dropdown-item logout-item" 
           href="<?php echo e(route('logout')); ?>"
           onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
           style="color: white;">
            Logout
        </a>

        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
            <?php echo csrf_field(); ?>
        </form>
    </div>
</li>

<style>
    /* Inline hover fix */
    .dropdown-menu .logout-item:hover {
        background-color: rgb(113,16,62) !important;
        color: white !important;
        opacity: 0.85; /* optional subtle effect */
    }
</style>

            <?php endif; ?>
        </ul>

        <a href="https://www.google.com/search" target="_blank" rel="noopener" title="Search">
            <svg class="search-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <circle cx="11" cy="11" r="8"></circle>
                <path d="m21 21-4.35-4.35"></path>
            </svg>
        </a>

        <div class="hamburger" id="hamburger">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>

    <ul class="nav-links-mobile" id="navLinksMobile">
        <li><a href="#dashboard">Dashboard</a></li>
        <li><a href="#analytics">Analytics</a></li>
        <li><a href="#reports">Reports</a></li>
        <li><a href="#contact">Contact</a></li>

        
        <li><a href="<?php echo e(url('/about')); ?>">About Us</a></li>
        <li><a href="<?php echo e(url('/contact')); ?>">Contact Us</a></li>
        <li><a href="<?php echo e(url('/chat')); ?>">Online Chat</a></li>
        <li><a href="<?php echo e(url('/faqs')); ?>">FAQs</a></li>

        
        <?php if(auth()->guard()->guest()): ?>
            <?php if(Route::has('login')): ?>
                <li><a href="<?php echo e(route('login')); ?>">Login</a></li>
            <?php endif; ?>

            <?php if(Route::has('register')): ?>
                <li><a href="<?php echo e(route('register')); ?>">Register</a></li>
            <?php endif; ?>
        <?php else: ?>
            <li>
                <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form-mobile').submit();">
                    Logout (<?php echo e(Auth::user()->name); ?>)
                </a>

                <form id="logout-form-mobile" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                    <?php echo csrf_field(); ?>
                </form>
            </li>
        <?php endif; ?>
    </ul>
</nav>


        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>

        </main>
    </div>
    <footer class="bg-wine-gradient text-white text-center py-3 px-4 rounded-top shadow"
        style="position: fixed; bottom: 0; left: 0; width: 100%;">
    <small>
        &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
    </small>
</footer>
</body>
</html>
<?php /**PATH E:\CareerJobs\resources\views\layouts\manager\app.blade.php ENDPATH**/ ?>