<!DOCTYPE html>
<html>
<head>
<meta name="color-scheme" content="light dark">
<meta name="supported-color-schemes" content="light dark">
</head>

<?php
    $brandPrimary = 'rgb(113,16,62)';
    $brandLight = '#faf0f5';
    $brandAccent = '#fdf3f7';
    $textColor = '#333';
    $darkTextColor = '#e6e6e6';
    $darkBg = '#1a1a1a';
    $darkCard = '#2a2a2a';

    $ics = urlencode("BEGIN:VCALENDAR
VERSION:2.0
BEGIN:VEVENT
DTSTART:{$startTimeUtc}
DTEND:{$endTimeUtc}
SUMMARY:Interview with {$sender}
DESCRIPTION:" . strip_tags($description) . "
LOCATION:Google Meet
URL:{$meetUrl}
END:VEVENT
// END:VCALENDAR");
?>

<body style="margin:0; padding:0; background:#f7f7f9; color:<?php echo e($textColor); ?>;">

<div style="
    font-family: 'Segoe UI', Arial, sans-serif;
    padding: 20px;
    background:#f7f7f9;
">

    <div style="
        max-width:600px;
        width:100%;
        margin:auto;
        background:white;
        border-radius:12px;
        padding:25px;
        box-shadow:0 4px 18px rgba(0,0,0,0.08);
        line-height:1.7;
    ">

        <h2 style="
            margin-top:0;
            color:<?php echo e($brandPrimary); ?>;
            font-weight:700;
            font-size:22px;
            text-align:center;
        ">
            Interview Invite
        </h2>

        <p>Hi <?php echo e($applicant); ?>,</p>

        <div style="
            background:<?php echo e($brandAccent); ?>;
            border-left:4px solid <?php echo e($brandPrimary); ?>;
            padding:15px;
            border-radius:6px;
            margin:20px 0;
        ">
            <?php echo $description; ?>

        </div>

        <div style="
            background:<?php echo e($brandLight); ?>;
            border-left:4px solid <?php echo e($brandPrimary); ?>;
            padding:12px 18px;
            border-radius:6px;
            margin:20px 0;
        ">
            <p style="margin:0;">
                <strong>Date:</strong> <?php echo e($date); ?><br>
                <strong>Time:</strong> <?php echo e($startTime); ?> – <?php echo e($endTime); ?><br>
                <strong>Add to Calendar:</strong>
                <a href="data:text/calendar;charset=utf8,<?php echo e($ics); ?>" 
                   style="color:<?php echo e($brandPrimary); ?>; font-weight:600;">
                   Interview.ics
                </a>
            </p>
        </div>

        <p>You can join the meeting using the button below:</p>

        <p style="text-align:center; margin:30px 0;">
            <a href="<?php echo e($meetUrl); ?>" 
               style="
                    display:inline-block;
                    padding:14px 22px;
                    background:<?php echo e($brandPrimary); ?>;
                    color:white;
                    text-decoration:none;
                    border-radius:8px;
                    font-weight:600;
                    font-size:16px;
               ">
                Join Google Meet
            </a>
        </p>

        <p>
            You can also log in to your account and find this interview under 
            <strong>Upcoming Interviews</strong>.
        </p>

        <p>We look forward to speaking with you soon.</p>

        <p style="margin-top:35px;">
            Regards,<br>
            <strong><?php echo e($sender); ?></strong>
        </p>

        <div style="
            margin-top:40px;
            text-align:center;
            font-size:13px;
            color:#777;
        ">
            © <?php echo e(date('Y')); ?> CareerJobs. All rights reserved.
        </div>

    </div>
</div>

<!-- DARK MODE OVERRIDES -->
<style>
@media (prefers-color-scheme: dark) {
    body { background: <?php echo e($darkBg); ?> !important; color: <?php echo e($darkTextColor); ?> !important; }
    div[style*="background:white"] {
        background: <?php echo e($darkCard); ?> !important;
        color: <?php echo e($darkTextColor); ?> !important;
    }
    a { color: <?php echo e($brandPrimary); ?> !important; }
}
</style>

</body>
</html>



<?php /**PATH E:\CareerJobs\resources\views/emails/interview_scheduled.blade.php ENDPATH**/ ?>