<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Notifications -->
    <script src="https://cdn.jsdelivr.net/npm/notiflix/dist/notiflix-aio-3.2.6.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- Google Maps -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyACo1W7kVL0SRaMfxkHmQrbv0G-ELGCVFk&libraries=places&callback=initSuburbAutocomplete" async defer></script>

    <!-- SCEditor -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sceditor@3/minified/themes/default.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/sceditor@3/minified/sceditor.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sceditor@3/minified/formats/bbcode.js"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>

<body class="bg-light">
    <div id="app" class="d-flex flex-column min-vh-100">

        <!-- Navbar -->
        <nav class="navbar navbar-expand-md navbar-dark shadow-sm">
            <div class="container">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminSidebar" aria-controls="adminSidebar" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
      
                <a class="navbar-brand fw-bold text-uppercase" href="<?php echo e(url('/')); ?>">
              <?php echo e(config('app.name', 'Laravel')); ?>


                </a>

                <div class="d-none d-md-flex ms-auto align-items-center">
                    <?php if(auth()->guard()->guest()): ?>
                        <a class="nav-link fw-semibold" href="<?php echo e(route('login')); ?>">
                            <i class="fa-solid fa-right-to-bracket me-1"></i> Login
                        </a>
                    <?php else: ?>
                        <div class="dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fa-solid fa-user-circle me-1"></i> <?php echo e(Auth::user()->name); ?>

                            </a>

                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i class="fa-solid fa-right-from-bracket me-1"></i> Logout
                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </nav>

        <!-- Page Layout -->
        <div class="container-fluid">
            <div class="row">
                <!-- SIDEBAR (TOGGLED BY HAMBURGER) -->
                <aside id="adminSidebar" class="collapse d-md-block col-12 col-md-3 col-lg-2 bg-light sidebar border-end">
                    <?php echo $__env->make('layouts.admin.adminsidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </aside>

                <!-- MAIN CONTENT -->
                <main class="col-12 col-md-9 col-lg-10 px-4" style="margin-top: 12px !important;">
                    <div class="card border-0 bg-white rounded-3 shadow-sm mb-4">
                        <div class="card-body">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                    </div>
                </main>
            </div>
        </div>

        <!-- Footer -->
        <footer class="bg-white border-top text-center py-3">
            <small class="text-muted">&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</small>
        </footer>
    </div>
</body>
</html>
<?php /**PATH E:\CareerJobs\resources\views\layouts\admin\adminapp.blade.php ENDPATH**/ ?>