<?php $__env->startSection('content'); ?>

<style>
    body {
        background: #f5f6fa;
        margin: 12px;
    }

    .dashboard-container {
        padding: 30px 0;
    }

    .dashboard-title {
        font-size: 32px;
        font-weight: 800;
        color: rgb(113, 16, 62);
        margin-bottom: 25px;
    }

    /* Dashboard Card */
    .dash-card {
        background: #fff;
        border-radius: 18px;
        padding: 25px;
        border: 1px solid #eee;
        transition: .25s ease;
        cursor: pointer;
        height: 100%;
    }
    .dash-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px rgba(113, 16, 62, 0.15);
        border-color: rgb(113, 16, 62);
    }

    .dash-card h5 {
        font-weight: 700;
        color: rgb(113, 16, 62);
    }

    /* Progress Bar */
    .progress {
        height: 10px;
        border-radius: 20px;
        background: #eee;
    }
    .progress-bar {
        background: rgb(113, 16, 62);
    }

    /* Jobs Applied List */
    .job-applied-card {
        background: #fff;
        border-radius: 16px;
        padding: 20px;
        border: 1px solid #eee;
        transition: .25s ease;
    }
    .job-applied-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(113, 16, 62, 0.15);
        border-color: rgb(113, 16, 62);
    }

    .job-applied-logo {
        width: 55px;
        height: 55px;
        border-radius: 10px;
        object-fit: cover;
        background: #fafafa;
        border: 1px solid #ddd;
    }

    .job-applied-title {
        font-size: 18px;
        font-weight: 700;
        color: rgb(113, 16, 62);
    }

    .job-applied-company {
        font-size: 14px;
        color: #555;
    }

    .status-badge {
        padding: 6px 12px;
        border-radius: 999px;
        font-size: 13px;
        font-weight: 600;
        display: inline-block;
    }

    .status-pending {
        background: #fff3cd;
        color: #856404;
    }
    .status-reviewed {
        background: #d1ecf1;
        color: #0c5460;
    }
    .status-shortlisted {
        background: #d4edda;
        color: #155724;
    }

    /* Recommended Jobs */
    .recommended-card {
        background: #fff;
        border-radius: 16px;
        padding: 18px;
        border: 1px solid #eee;
        transition: .25s ease;
        cursor: pointer;
    }
    .recommended-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(113, 16, 62, 0.15);
        border-color: rgb(113, 16, 62);
    }

    .find-jobs-banner {
        background: linear-gradient(135deg, rgb(113, 16, 62), rgb(150, 30, 80));
        padding: 25px;
        border-radius: 20px;
        color: white;
        margin-bottom: 35px;
        box-shadow: 0 10px 25px rgba(113, 16, 62, 0.25);
    }
    .find-jobs-banner h3 {
        font-weight: 800;
        margin-bottom: 10px;
    }
    .find-jobs-banner button {
        background: white;
        color: rgb(113, 16, 62);
        border: none;
        padding: 12px 20px;
        border-radius: 12px;
        font-weight: 700;
        transition: .25s;
    }
    .find-jobs-banner button:hover {
        transform: translateY(-2px);
        background: #f5f5f5;
    }

    .recommended-card {
    background: #ffffff;
    border-radius: 12px;
    padding: 18px;
    border: 1px solid #e5e5e5;
    transition: all 0.25s ease;
    cursor: pointer;
    height: 100%;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.recommended-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 6px 16px rgba(0,0,0,0.12);
    border-color: #c7c7c7;
}

.recommended-card h6 {
    font-size: 1.05rem;
    margin-bottom: 6px;
}

.recommended-card p {
    margin: 0;
}

.recommended-card small {
    font-size: 0.85rem;
}

.recommended-card.platinum {
    border: 2px solid #6a1b9a;
    background: #f3e5f5;
}

.recommended-card.premium {
    border: 2px solid #b8860b;
    background: #fff8e1;
}

.bg-purple {
    background-color: #6a1b9a !important;
    color: #fff !important;
}


    /* Wider, premium offcanvas */
    #applyCanvas.offcanvas-start {
        width: 480px !important; /* Increase width */
        max-width: 90vw;
        border-right: 4px solid rgb(113,16,62);
        box-shadow: -8px 0 35px rgba(113,16,62,0.25);
        animation: slideInCanvas .35s ease-out;
    }



    /* Header styling */
    #applyCanvas .offcanvas-header {
        background: rgb(113,16,62);
        color: white;
        padding: 20px;
        border-bottom: 3px solid rgba(0,0,0,0.15);
    }

    #applyCanvas .offcanvas-header h5 {
        font-weight: 700;
        letter-spacing: 0.5px;
    }

    #applyCanvas .btn-close {
        filter: invert(1);
        opacity: 0.9;
    }

    /* Section titles */
    #applyCanvas .section-title {
        font-weight: 700;
        color: rgb(113,16,62);
        margin-top: 25px;
        margin-bottom: 10px;
        font-size: 15px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Job header box */
    .apply-header-box {
        background: rgba(116,62,16,0.08);
        border-left: 4px solid rgb(113,16,62);
        padding: 15px 18px;
        border-radius: 6px;
    }

    .apply-header-box h4 {
        margin: 0;
        font-weight: 700;
        color: rgb(113,16,62);
    }

    /* Submit button */
    #applyCanvas button[type="submit"] {
        background: rgb(113,16,62);
        border: none;
        padding: 12px;
        font-size: 16px;
        border-radius: 6px;
    }

    #applyCanvas button[type="submit"]:hover {
        background:rgb(113,16,62);
    }



</style>

<div class="container dashboard-container">

    <h2 class="dashboard-title">
        <i class="fa-solid fa-user-circle me-2"></i> Welcome, <?php echo e(auth()->user()->name); ?>

    </h2>

    <!-- FIND JOBS BANNER -->
    <div class="find-jobs-banner">
        <h3>Find Your Next Opportunity</h3>
        <p>Browse thousands of jobs tailored to your skills and interests.</p>
        <button onclick="window.location.href='/jobs'">
            <i class="fa-solid fa-magnifying-glass me-2"></i> Browse Jobs
        </button>
    </div>

    <!-- Dashboard Overview -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="dash-card">
                <h5><i class="fa-solid fa-briefcase me-2"></i> Jobs Applied</h5>
                <p class="text-muted mb-0"><?php echo e($appliedJobs->count()); ?> applications</p>
            </div>
        </div>

        <div class="col-md-3">
            <div class="dash-card">
                <h5><i class="fa-solid fa-heart me-2"></i> Saved Jobs</h5>
                <p class="text-muted mb-0"><?php echo e($savedJobs->count()); ?> saved</p>
            </div>
        </div>

        <div class="col-md-3">
            <div class="dash-card text-center">
                <h5><i class="fa-solid fa-file-lines me-2"></i> Resume</h5>
                <?php if(auth()->user()->resume_path): ?>
                    <p class="text-success fw-bold mb-1">Uploaded</p>
                    <a href="<?php echo e(asset('storage/' . auth()->user()->resume_path)); ?>" target="_blank" class="small d-block mb-2">View Resume</a>
                <?php else: ?>
                    <p class="text-danger fw-bold mb-1">Not Uploaded</p>
                <?php endif; ?>
                <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#resumeModal">
                    <?php echo e(auth()->user()->resume_path ? 'Update Resume' : 'Upload Resume'); ?>

                </button>
            </div>
        </div>

        <div class="col-md-3">
            <div class="dash-card text-center">
                <h5><i class="fa-solid fa-pen-to-square me-2"></i> Cover Letter</h5>
                <?php if(auth()->user()->cover_letter_path): ?>
                    <p class="text-success fw-bold mb-1">Uploaded</p>
                    <a href="<?php echo e(asset('storage/' . auth()->user()->cover_letter_path)); ?>" target="_blank" class="small d-block mb-2">View Cover Letter</a>
                <?php else: ?>
                    <p class="text-danger fw-bold mb-1">Not Uploaded</p>
                <?php endif; ?>
                <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#coverLetterModal">
                    <?php echo e(auth()->user()->cover_letter_path ? 'Update Cover Letter' : 'Upload Cover Letter'); ?>

                </button>
            </div>
        </div>

        
    </div>

    <!-- Account Insights -->
    <h4 class="mb-3 fw-bold text-wine">
        <i class="fa-solid fa-chart-line me-2"></i> Account Insights
    </h4>

    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="dash-card">
                <h5><i class="fa-solid fa-eye me-2"></i> Skills</h5>
                <p class="text-muted mb-0">20 Skills</p>
            </div>
        </div>

        <div class="col-md-4">
            <div class="dash-card">
                <h5><i class="fa-solid fa-clock-rotate-left me-2"></i> Last Login</h5>
                <p class="text-muted mb-0"><?php echo e(auth()->user()->last_login ?? 'Today'); ?></p>
            </div>
        </div>

        <div class="col-md-4">
            <div class="dash-card">
                <h5><i class="fa-solid fa-star me-2"></i> Profile Strength</h5>
                <p class="text-muted mb-0">Strong</p>
            </div>
        </div>
    </div>

    <!-- Jobs Applied Section -->
    <h4 class="mb-3 fw-bold text-wine">
        <i class="fa-solid fa-list-check me-2"></i> Your Applications
    </h4>

    <div class="row g-4 mb-5">
        <?php $__empty_1 = true; $__currentLoopData = $appliedJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <script>
    window.appliedJobs = window.appliedJobs || {};
    window.appliedJobs[<?php echo e($job->id); ?>] = <?php echo json_encode($job, 15, 512) ?>;
</script>
            <div class="col-md-6">
                <div class="job-applied-card" onclick="showAppliedPopup(<?php echo e($job->id); ?>)">
                    <div class="d-flex align-items-center mb-3">
                        <?php if($job->logo): ?>
                            <img src="<?php echo e(asset('storage/' . $job->logo)); ?>" class="job-applied-logo me-3">
                        <?php else: ?>
                            <div class="job-applied-logo d-flex align-items-center justify-content-center text-muted me-3">
                                <i class="fa-solid fa-building"></i>
                            </div>
                        <?php endif; ?>
                        <div>
                            <div class="job-applied-title"><?php echo e($job->job_title); ?></div>
                            <div class="job-applied-company"><?php echo e($job->company); ?></div>
                        </div>
                    </div>
                    <p class="mb-2"><strong>Applied on:</strong> <?php echo e($job->pivot->created_at->format('d M Y')); ?></p>
                    <span class="status-badge 
                        <?php if($job->pivot->status == 'Pending'): ?> status-pending
                        <?php elseif($job->pivot->status == 'Reviewed'): ?> status-reviewed
                        <?php elseif($job->pivot->status == 'Shortlisted'): ?> status-shortlisted
                        <?php endif; ?>
                    ">
                        <?php echo e($job->pivot->status); ?>

                    </span>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-muted">You haven't applied for any jobs yet.</p>
        <?php endif; ?>
    </div>

    <!-- Recommended Jobs -->
    <h4 class="mb-3 fw-bold text-wine">
        <i class="fa-solid fa-thumbs-up me-2"></i> Recommended for You
    </h4>

<div class="row g-4 mb-5">
    <?php $__currentLoopData = $recommendedJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $tier = strtolower($job->ad_type ?? 'basic');
        ?>

        <div class="col-md-4">
            <div class="recommended-card <?php echo e($tier); ?>" onclick="openJobDetails(<?php echo e($job->id); ?>)">
                
                <?php if($tier === 'platinum'): ?>
                    <span class="badge bg-purple mb-2">Actively Hiring</span>
                <?php endif; ?>

                <h6 class="fw-bold text-wine"><?php echo e($job->job_title); ?></h6>
                <p class="text-muted mb-1"><?php echo e($job->company); ?></p>
                <small class="text-muted"><?php echo e($job->location); ?></small>
            
            </div>
        </div>

        <script>
    window.jobsData = window.jobsData || {};
    window.jobsData[<?php echo e($job->id); ?>] = <?php echo json_encode($job, 15, 512) ?>;
</script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


</div>


<div class="offcanvas offcanvas-end fancy-offcanvas" tabindex="-1" id="jobDetailsCanvas">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa-solid fa-briefcase me-2"></i> Job Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body" id="jobDetailsContent">
        <div class="text-center text-muted">Loading...</div>
    </div>
</div>


<style>
    /* OFFCANVAS WRAPPER */
    .fancy-offcanvas {
        width: 520px !important;
        background: rgba(255, 255, 255, 0.85);
        backdrop-filter: blur(14px);
        border-left: 5px solid rgb(113, 16, 62);
        box-shadow: -8px 0 35px rgba(113, 16, 62, 0.25);
        animation: slideInCanvas .35s ease-out;
    }

    @keyframes slideInCanvas {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }

    /* HEADER */
    .fancy-offcanvas .offcanvas-header {
        background: linear-gradient(135deg, rgb(113, 16, 62), rgb(150, 30, 80));
        color: white;
        padding: 22px;
        border-bottom: 1px solid rgba(255,255,255,0.2);
    }

    .offcanvas-title {
        font-size: 20px;
        font-weight: 700;
        letter-spacing: -0.3px;
    }

    /* BODY */
    .fancy-offcanvas .offcanvas-body {
        padding: 25px 28px;
        overflow-y: auto;
    }

    /* JOB HEADER */
    .job-header-block img {
        width: 70px;
        height: 70px;
        border-radius: 14px;
        object-fit: cover;
        border: 2px solid #eee;
        background: #fff;
    }

    .job-header-block h3 {
        font-size: 22px;
        font-weight: 800;
        color: rgb(113, 16, 62);
        margin-top: 10px;
    }

    .job-header-block small {
        font-size: 13px;
        color: #777;
    }

    /* SECTION TITLES */
    .section-title {
        font-weight: 700;
        font-size: 15px;
        margin-top: 22px;
        margin-bottom: 8px;
        color: rgb(113, 16, 62);
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .section-title i {
        color: rgb(113, 16, 62);
    }

    /* INFO TEXT BLOCKS */
    .info-text {
        background: #fff;
        border-radius: 12px;
        padding: 14px;
        border: 1px solid #e5e5e5;
        font-size: 14px;
        line-height: 1.55;
        color: #444;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    }

    /* QUICK APPLY BUTTON */
    .quick-apply-btn {
        background: rgb(113, 16, 62);
        color: white;
        border: none;
        padding: 14px 20px;
        border-radius: 12px;
        font-weight: 700;
        width: 100%;
        margin-top: 25px;
        transition: .25s ease;
        font-size: 15px;
    }
    .quick-apply-btn:hover {
        background: rgb(48, 51, 233);
        transform: translateY(-2px);
        box-shadow: 0 6px 18px rgba(113, 16, 62, 0.25);
    }

    /* DIVIDER */
    .canvas-divider {
        margin: 20px 0;
        border-top: 1px solid #ddd;
    }
/* Apply Modal Styles */ */

/* FORCE full height for top offcanvas */
#applyCanvas.offcanvas-top {
    height: 100vh !important;
    max-height: 100vh !important;
    transform: translateY(0) !important;
    border-bottom: 4px solid rgb(113,16,62);
}

/* FIX Bootstrap inline styles overriding height */
#applyCanvas {
    height: 100vh !important;
    max-height: 100vh !important;
}

/* Scrollable body */
#applyCanvas .offcanvas-body {
    height: calc(100vh - 70px); /* subtract header height */
    overflow-y: auto;
    padding-bottom: 40px;
}

/* Header styling */
#applyCanvas .offcanvas-header {
    background:  rgb(113,16,62);
    color: white;
    padding: 20px;
    border-bottom: 3px solid rgba(0,0,0,0.15);
}

#applyCanvas .btn-close {
    filter: invert(1);
    opacity: 0.9;
}

/* Section titles */
.section-title {
    font-weight: 700;
    color: rgb(113,16,62);
    margin-bottom: 10px;
    border-left: 4px solid rgb(113,16,62);
    padding-left: 8px;
}

/* Job header box */
.apply-header-box {
    background: rgba(116,62,16,0.08);
    border-left: 4px solid rgb(113,16,62);
    padding: 15px 18px;
    border-radius: 6px;
}

/* Submit button */
#applyCanvas button[type="submit"] {
    background:  rgb(113,16,62);
    border: none;
    padding: 12px;
    font-size: 16px;
    border-radius: 6px;
        margin-bottom: 24px;
}

#applyCanvas button[type="submit"]:hover {
    background:  rgb(84, 7, 229);

}
#applyCanvas .apply-inner
 { padding: 24px;
     height: 100%; 
    
}






/* Modal styling */
.applied-modal {
    border-radius: 14px;
    overflow: hidden;
    border: none;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
}

/* Header */
.applied-modal .modal-header {
    background: rgb(113,16,62);
    color: white;
    border-bottom: none;
    padding: 20px;
}

.applied-modal .btn-close {
    filter: invert(1);
}

/* Job info box */
.applied-header-box {
    background: rgba(116,62,16,0.08);
    border-left: 4px solid rgb(113,16,62);
    padding: 15px 18px;
    border-radius: 6px;
}

.applied-header-box h4 {
    margin: 0;
    font-weight: 700;
    color: rgb(113,16,62);
}

.applied-header-box small {
    font-size: 14px;
    color: #555;
}

/* Status badge */
#appliedJobStatus {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
}

/* Status colors */
.status-pending { background: #ffe9a3; color: #8a6d00; }
.status-reviewed { background: #cce5ff; color: #004085; }
.status-shortlisted { background: #d4edda; color: #155724; }

/* Footer button */
.applied-modal .modal-footer button {
    background: rgb(113,16,62);
    border: none;
    padding: 12px;
    font-size: 16px;
    border-radius: 6px;
}

.applied-modal .modal-footer button:hover {
    background: rgb(113,16,62);
}
</style>




<!-- Resume Upload Modal -->
<div class="modal fade" id="resumeModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" method="POST" action="<?php echo e(route('resume.upload')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">Upload Resume</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <label class="form-label">Choose Resume (PDF, DOCX)</label>
                <input type="file" name="resume" class="form-control" required>
            </div>

            <div class="modal-footer">
                <button class="btn btn-primary">Upload</button>
            </div>
        </form>
    </div>
</div>

<!-- Cover Letter Upload Modal -->
<div class="modal fade" id="coverLetterModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" method="POST" action="<?php echo e(route('coverletter.upload')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">Upload Cover Letter</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <label class="form-label">Choose Cover Letter (PDF, DOCX)</label>
                <input type="file" name="cover_letter" class="form-control" required>
            </div>

            <div class="modal-footer">
                <button class="btn btn-primary">Upload</button>
            </div>
        </form>
    </div>
</div>


<div class="offcanvas offcanvas-top applyModal" tabindex="-1" id="applyCanvas">
    <div class="offcanvas-header">
        <h5 class="fw-bold">Quick Apply</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body">
        <div class="apply-inner">
        <form id="applicationForm" enctype="multipart/form-data">

            <div class="apply-header-box mb-4">
                <h4 id="applyJobTitle">Job Title Here</h4>
                <small id="applyCompanyName">Company Name Here</small><br>
                <small class="fw-bold">Job ID: <span id="applyJobId"></span></small>
            </div>

            <h6 class="section-title">Resume</h6>

            <?php if(auth()->user()->resume_path): ?>
                <div class="form-check mb-2">
                    <input class="form-check-input" type="radio" name="resume_option" value="existing" checked>
                    <label class="form-check-label">
                        Use existing resume  
                        <a href="<?php echo e(asset('storage/' . auth()->user()->resume_path)); ?>" target="_blank">(View)</a>
                    </label>
                </div>
            <?php endif; ?>

            <div class="form-check mb-3">
                <input class="form-check-input" type="radio" name="resume_option" value="upload">
                <label class="form-check-label">Upload new resume</label>
            </div>

            <input type="file" name="resume" id="resumeUpload" class="form-control mb-4" style="display:none;">

            <h6 class="section-title">Cover Letter</h6>

            <?php if(auth()->user()->cover_letter_path): ?>
                <div class="form-check mb-2">
                    <input class="form-check-input" type="radio" name="cover_option" value="existing" checked>
                    <label class="form-check-label">
                        Use existing cover letter  
                        <a href="<?php echo e(asset('storage/' . auth()->user()->cover_letter_path)); ?>" target="_blank">(View)</a>
                    </label>
                </div>
            <?php endif; ?>

            <div class="form-check mb-3">
                <input class="form-check-input" type="radio" name="cover_option" value="upload">
                <label class="form-check-label">Upload new cover letter</label>
            </div>

            <input type="file" name="cover_letter" id="coverUpload" class="form-control mb-4" style="display:none;">

            <h6 class="section-title">Employer Questions</h6>
            <div id="questionsContainer" class="mb-3">
                <p class="text-muted">Loading questions...</p>
            </div>

            <button class="btn btn-primary w-100 fw-bold mt-3" type="submit">
                Submit Application
            </button>

        </form>
        </div>
    </div>
</div>


<div class="modal fade" id="appliedJobModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content applied-modal">

            <div class="modal-header">
                <h5 class="modal-title fw-bold">Application Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="applied-header-box mb-3">
                    <h4 id="appliedJobTitle"></h4>
                    <small id="appliedJobCompany"></small><br>
                    <span class="badge mt-2" id="appliedJobStatus"></span>
                </div>

                <p class="text-muted mt-3">
                    You have already applied for this job.  
                    An email will be sent to you regarding the outcome of your application.
                </p>
            </div>

            <div class="modal-footer">
                <button class="btn btn-primary w-100" data-bs-dismiss="modal">Okay</button>
            </div>

        </div>
    </div>
</div>




<script>
    window.jobsData = {};
</script>

<script>

document.addEventListener("DOMContentLoaded", function () {

    window.openJobDetails = function(id) {

            //  Track the view immediately 
                fetch(`/job-viewed/${id}`, { 
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                })
                .then(res => res.json())
                .then(data => console.log("VIEW TRACK:", data))
                .catch(err => console.error("VIEW ERROR:", err));

        const url = `/swjobs/${id}`;

        fetch(url)
            .then(res => {
                if (!res.ok) throw new Error('Network response was not ok');
                return res.json();
            })
            .then(job => {
                window.jobsData = window.jobsData || {};
            // Only store if not already stored (Blade version has questions)
                if (!window.jobsData[job.id] || !window.jobsData[job.id].questions) {
                    window.jobsData[job.id] = job;
                }



                let html = `
                    <div class="job-header-block text-center mb-3">
                        <h3>${job.job_title}</h3>
                        <p class="text-muted mb-0">${job.company}</p>
                        <small>Expires: ${job.expiry_date}</small>
                        <small class="d-block">Job ID: ${job.id}</small>
                    </div>

                    <div class="canvas-divider"></div>

                    <h6 class="section-title"><i class="fa-solid fa-circle-info"></i> Job Informations</h6>
                    <div class="info-text">
                        <p><strong>Category:</strong> ${job.category ?? ''}</p>
                        <p><strong>Location:</strong> ${job.location ?? ''}</p>
                        <p><strong>Workplace:</strong> ${job.workplace ?? ''}</p>
                        <p><strong>Work Type:</strong> ${job.work_type ?? ''}</p>
                        <p><strong>Pay Type:</strong> ${job.pay_type ?? ''}</p>
                        <p><strong>Pay Range:</strong> ${job.pay_min ?? ''} - ${job.pay_max ?? ''}</p>
                    </div>

                    <h6 class="section-title"><i class="fa-solid fa-align-left"></i> Summary</h6>
                    <div id="summaryContainer" class="info-text">${job.summary_html ?? ''}</div>

                    <h6 class="section-title"><i class="fa-solid fa-file-lines"></i> Description</h6>
                    <div id="descriptionContainer" class="info-text">${job.description_html ?? ''}</div>

                    <button class="quick-apply-btn" onclick="quickApply(${job.id})">
                        <i class="fa-solid fa-paper-plane me-2"></i> Quick Apply
                    </button>
                `;

                document.getElementById('jobDetailsContent').innerHTML = html;

                const canvas = new bootstrap.Offcanvas(document.getElementById('jobDetailsCanvas'));
                canvas.show();
            })
            .catch(err => console.error(err));
    };
});

window.quickApply = function(jobId) {
    const job = window.jobsData[jobId];

    window.currentJob = window.jobsData[jobId];


    const detailsCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('jobDetailsCanvas'));
if (detailsCanvas) detailsCanvas.hide();


    window.jobsData = window.jobsData || {};

if (!window.jobsData[jobId] || !window.jobsData[jobId].questions) {
    window.jobsData[jobId] = job;
}


        const isLoggedIn = <?php echo json_encode(auth()->check(), 15, 512) ?>;
    const loginUrl   = <?php echo json_encode(route('login'), 15, 512) ?>;

    console.log("Displaying questions for job:", jobId, job ? job.questions : "NO JOB FOUND");

    if (!isLoggedIn) {
        window.location.href = loginUrl;
        return;
    }

    if (!job) {
        console.error("Job not found in jobsData:", jobId);
        return;
    }

    document.getElementById("applyJobTitle").innerText = job.job_title;
    document.getElementById("applyCompanyName").innerText = job.company;
    document.getElementById("applyJobId").innerText = job.id;

    new bootstrap.Offcanvas('#applyCanvas').show();

    displayEmployerQuestions(jobId);
};




document.addEventListener("change", function(e) {
    if (e.target.name === "resume_option") {
        document.getElementById('resumeUpload').style.display =
            e.target.value === "upload" ? "block" : "none";
    }

    if (e.target.name === "cover_option") {
        document.getElementById('coverUpload').style.display =
            e.target.value === "upload" ? "block" : "none";
    }
});



function displayEmployerQuestions(jobId) {
    const container = document.getElementById('questionsContainer');
    if (!container) return;

    const job = window.jobsData[jobId];   // FIX: get job object

console.log("Displaying questions for job:", jobId, job ? job.questions : "NO JOB FOUND");

    container.innerHTML = '';

    if (!job || !job.questions || job.questions.length === 0) {
        container.innerHTML = `<p class="text-muted">No employer questions for this job.</p>`;
        return;
    }

    let html = '';

    job.questions.forEach(q => {
        html += `
            <div class="mb-3">
                <label class="fw-semibold">
    ${q.label} <span class="text-danger">*</span>
</label>

                ${renderQuestionInput(q)}
            </div>
        `;
    });

    container.innerHTML = html;
}



function renderQuestionInput(q) {
    switch (q.type) {

        case 'text':
            return `<input type="text" class="form-control" name="question_${q.id}" required>`;

        case 'textarea':
            return `<textarea class="form-control" rows="3" name="question_${q.id}" required></textarea>`;

        case 'boolean':
            return `
                <select class="form-select" name="question_${q.id}" required>
                    <option value="">Select</option>
                    <option value="Yes">Yes</option>
                    <option value="No">No</option>
                </select>
            `;

        case 'number':
            return `<input type="number" class="form-control" name="question_${q.id}" required>`;

        case 'select':
            const opts = q.options ? q.options.split(',') : [];
            return `
                <select class="form-select" name="question_${q.id}" required>
                    <option value="">Select</option>
                    ${opts.map(o => `<option value="${o.trim()}">${o.trim()}</option>`).join('')}
                </select>
            `;

        default:
            return `<input type="text" class="form-control" name="question_${q.id}" required>`;
    }
}



document.addEventListener("change", function (e) {
    if (e.target.name === "resume_option") {
        document.getElementById("resumeUpload").style.display =
            e.target.value === "upload" ? "block" : "none";
    }

    if (e.target.name === "cover_option") {
        document.getElementById("coverUpload").style.display =
            e.target.value === "upload" ? "block" : "none";
    }
});



// window.quickApply = function(jobId) {
//     const job = window.jobsData[jobId];

//     const isLoggedIn = <?php echo json_encode(auth()->check(), 15, 512) ?>;
//     const loginUrl   = <?php echo json_encode(route('login'), 15, 512) ?>;

//     if (!isLoggedIn) {
//         window.location.href = loginUrl;
//         return;
//     }

//     window.currentJob = job;

//     document.getElementById("applyJobTitle").innerText = job.job_title;
//     document.getElementById("applyCompanyName").innerText = job.company;
//     document.getElementById("applyJobId").innerText = job.id;

//     const canvas = new bootstrap.Offcanvas(document.getElementById('applyCanvas'));
//     canvas.show();

//     displayEmployerQuestions(jobId);
// };




// Handle application form submission
document.getElementById("applicationForm").addEventListener("submit", function (e) {
    e.preventDefault();

    const formData = new FormData();

    // Job ID
    formData.append("job_id", window.currentJob.id);

    // Resume
    const resumeOption = document.querySelector('input[name="resume_option"]:checked')?.value;
    formData.append("resume_option", resumeOption);

    if (resumeOption === "upload") {
        const resumeFile = document.getElementById("resumeUpload").files[0];
        if (resumeFile) formData.append("resume", resumeFile);
    }

    // Cover letter
    const coverOption = document.querySelector('input[name="cover_option"]:checked')?.value;
    formData.append("cover_option", coverOption);

    if (coverOption === "upload") {
        const coverFile = document.getElementById("coverUpload").files[0];
        if (coverFile) formData.append("cover_letter", coverFile);
    }

    // Employer question answers
    const answers = {};
    document.querySelectorAll('#questionsContainer [name]').forEach(input => {
        answers[input.name] = input.value;
    });

    formData.append("answers", JSON.stringify(answers));

    fetch("/apply-job", {
    method: "POST",
    headers: {
        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
    },
    body: formData
})
.then(async res => {
    if (!res.ok) {
        throw new Error("Server returned an error");
    }

    // Try to parse JSON safely
    let data = {};
    try {
        data = await res.json();
    } catch (e) {
        // If JSON fails, still treat as success
        console.warn("Response was not JSON, but request succeeded.");
    }

    Notiflix.Notify.success("Application submitted successfully!");

    // Close offcanvas instead of modal
    const applyCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('applyCanvas'));
    if (applyCanvas) applyCanvas.hide();

    setTimeout(() => window.location.reload(), 800);
})
.catch(err => {
    console.error(err);
    Notiflix.Notify.failure("Error submitting application.");
});

});




function showAppliedPopup(jobId) {
    const job = window.appliedJobs[jobId];
    if (!job) return;

    document.getElementById("appliedJobTitle").innerText = job.job_title;
    document.getElementById("appliedJobCompany").innerText = job.company;

    const statusBadge = document.getElementById("appliedJobStatus");
    statusBadge.innerText = job.pivot.status;

    // Apply status color class
    statusBadge.className = "badge status-" + job.pivot.status.toLowerCase();

    // Show modal
    new bootstrap.Modal(document.getElementById("appliedJobModal")).show();
}
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\CareerJobs\resources\views\home.blade.php ENDPATH**/ ?>