<!DOCTYPE html>
<html lang="en">

  <head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <title>CareerJobs</title>

    <!-- Bootstrap core CSS -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">


    <!-- Additional CSS Files -->
    <link rel="stylesheet" href="assets/css/fontawesome.css">
    <link rel="stylesheet" href="assets/css/templatemo-lugx-gaming.css">
    <link rel="stylesheet" href="assets/css/owl.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet"href="https://unpkg.com/swiper@7/swiper-bundle.min.css"/>
    <!-- Load Google Maps JS with Places library -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyACo1W7kVL0SRaMfxkHmQrbv0G-ELGCVFk&libraries=places&callback=initSuburbAutocomplete" async defer></script>


  </head>

<body>

  <!-- ***** Preloader Start ***** -->
  <div id="js-preloader" class="js-preloader">
    <div class="preloader-inner">
      <span class="dot"></span>
      <div class="dots">
        <span></span>
        <span></span>
        <span></span>
      </div>
    </div>
  </div>
  <!-- ***** Preloader End ***** -->

  <!-- ***** Header Area Start ***** -->
  <header class="header-area header-sticky">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav class="main-nav">
                    <!-- ***** Logo Start ***** -->
                    <a href="index.html" class="logo">
                        <img src="assets/images/logo.png" alt="Logo" style="max-width: 50px; width: 100%; height: auto;">
                    </a>
                    <!-- ***** Logo End ***** -->
                    <!-- ***** Menu Start ***** -->
                    <ul class="nav">
                        <li><a href="jobs.html">Job Search</a></li>
                        <li><a href="companies.html">Companies</a></li>
                        <li><a href="recruiters.html">Recruiters</a></li>
                        <li><a href="categories.html">Job Categories</a></li>
                        <li><a href="career-advice.html">Career Advice</a></li>
                        <li><a href="events.html">Job Fairs & Events</a></li>
                        {{-- <li><a href="dashboard.html">My Dashboard</a></li> --}}
                        {{-- <li><a href="contact.html">Contact Us</a></li> --}}
                        <li> <a href="/login"><button class="btn btn-s">Sign In</button></a></li>
                          <li><button id="openRegister" class="btn btn-s1">Sign Up</button></li>

                  </ul>   
                    <a class='menu-trigger'>
                        <span>Menu</span>
                    </a>
                    <!-- ***** Menu End ***** -->
                </nav>
            </div>
        </div>
    </div>
  </header>
  <!-- ***** Header Area End ***** -->
<div class="main-banner position-relative">
  <div class="container">
    <div class="row">
      
      <!-- Left side: text + search -->
      <div class="col-lg-6 align-self-center">
        <div class="caption header-text">
          <h6 class="banner-subtitle"></h6>
          <h2 class="banner-title">Find Your Next Job Today!</h2>
          <p class="banner-text">
            Discover thousands of opportunities from top companies and recruiters. 
            Whether you're looking for full-time, part-time, or freelance work, we've got you covered.
          </p>

          <!-- Benefits -->
          <ul class="banner-benefits">
            <li><i class="fa fa-check-circle text-success me-2"></i> Easy job search by category</li>
            <li><i class="fa fa-check-circle text-success me-2"></i> Thousands of verified listings</li>
            <li><i class="fa fa-check-circle text-success me-2"></i> Connect directly with recruiters</li>
          </ul>

          <!-- Search form -->
          <form id="search" action="#" class="row g-2 align-items-center banner-search mt-4">
            <div class="col-md-4">
              <select name="job-category" id="job-category" class="form-select" required>
                <option selected disabled value="">Select category</option>
                <option value="Support Workers">Support Workers</option>
                <option value="Senior Support Workers">Senior Support Workers</option>
                <option value="Service Managers">Service Managers</option>
                <option value="Operations Managers">Operations Managers</option>
                <option value="Social Workers">Social Workers</option>
                <option value="Administration Officers">Administration Officers</option>
                <option value="Nurses">Nurses</option>
                <option value="Team Leaders">Team Leaders</option>
                <option value="Business Managers">Business Managers</option>
              </select>
            </div>
            <div class="col-md-5">
              <input type="text" placeholder="Type a suburb" id="location" name="searchKeyword"
                     class="form-control" required autocomplete="off">
            </div>
            <div class="col-md-3 d-grid">
              <button type="submit" class="btn btn-gradient">Search Now</button>
            </div>
          </form>
        </div>
      </div>

      <!-- Right side: background image + Lottie -->
      <div class="col-lg-6 d-none d-lg-block position-relative">
        <div class="banner-bg"></div>
        <div class="lottie-overlay text-center">
          <script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.5/dist/dotlottie-wc.js" type="module"></script>
          <dotlottie-wc 
            src="https://lottie.host/4bc481b4-a36a-4e1c-bd3f-b669397804dd/LiF8EzjxCR.lottie" 
            style="width: 500px; height: 500px;" 
            autoplay loop>
          </dotlottie-wc>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Slide‑In Modal -->
<div id="registerModal" class="slide-modal-backdrop">
    <div class="slide-modal wine-panel">
        <div class="slide-modal-content">

            <!-- Close X -->
            <button type="button" class="modal-close-btn" id="closeRegisterModal">&times;</button>

            <!-- REGISTRATION FORM -->
            <div class="card shadow-lg border-0 rounded wine-card">
                <div class="card-header bg-wine text-center">
                    <h4 style="color: white !important;">
                        <i class="fa fa-user-plus me-2"></i> Create Your Account
                    </h4>
                </div>

                <div class="card-body p-4">
                    <form method="POST" action="/registeruser" id="registerForm">
                        @csrf
                        <!-- Name -->
                        <div class="mb-3">
                            <label class="form-label fw-bold text-wine">Full Name</label>
                            <div class="input-group">
                                <span class="input-group-text wine-input-icon"><i class="fa fa-user"></i></span>
                                <input type="text" name="name" class="form-control" required>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label class="form-label fw-bold text-wine">Email Address</label>
                            <div class="input-group">
                                <span class="input-group-text wine-input-icon"><i class="fa fa-envelope"></i></span>
                                <input type="email" name="email" class="form-control" required>
                            </div>
                        </div>

                        <!-- Password -->
                        <div class="mb-3">
                            <label class="form-label fw-bold text-wine">Password</label>
                            <div class="input-group">
                                <span class="input-group-text wine-input-icon"><i class="fa fa-lock"></i></span>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="mb-3">
                            <label class="form-label fw-bold text-wine">Confirm Password</label>
                            <div class="input-group">
                                <span class="input-group-text wine-input-icon"><i class="fa fa-check"></i></span>
                                <input type="password" name="password_confirmation" class="form-control" required>
                            </div>
                        </div>

                        <div class="d-grid mt-4">
                            <button type="submit" class="btn btn-wine btn-lg shadow-sm" id="registerBtn">
                                <span class="spinner-border spinner-border-sm me-2 d-none" id="registerSpinner" role="status" aria-hidden="true"></span>
                                <span id="registerBtnText">Register</span>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="card-footer text-center bg-light">
                    <small class="text-muted">
                        Already have an account? <a href="/login" class="text-wine fw-bold">Login here</a>
                    </small>
                </div>
            </div>

        </div>
    </div>
</div>





<style>
/* Backdrop (hidden by default) *//* Backdrop */
.slide-modal-backdrop {
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.55);
    display: none;
    align-items: center;
    justify-content: flex-end;
    z-index: 9999;
}

/* Show modal */
.slide-modal-backdrop.open {
    display: flex;
}

/* Slide-in panel */
.slide-modal {
    width: 500px;
    height: 100%;
    background: #fff;
    transform: translateX(100%);
    transition: transform 0.4s ease;
    box-shadow: -5px 0 25px rgba(0,0,0,0.25);
}

/* Slide in */
.slide-modal-backdrop.open .slide-modal {
    transform: translateX(0);
}

/* Wine theme */
.bg-wine {
    background-color: rgb(113, 16, 62) !important;
}

.text-wine {
    color: rgb(113, 16, 62) !important;
}

.btn-wine {
    background-color: rgb(113, 16, 62);
    color: #fff;
    border: none;
    border-radius: 8px;
}

.btn-wine:hover {
    background-color: #6b0f3e;
    color: #fff;
}

/* Wine card styling */
.wine-card {
    border: 1px solid rgba(113,16,62,0.25);
    border-radius: 14px;
}

/* Inputs */
.wine-input {
    border-radius: 0 8px 8px 0;
    border: 1px solid rgba(113,16,62,0.3);
}

.wine-input:focus {
    border-color: rgb(113,16,62);
    box-shadow: 0 0 0 0.2rem rgba(113,16,62,0.25);
}

.wine-input-icon {
    background: rgba(113,16,62,0.1);
    color: rgb(113,16,62);
    border-radius: 8px 0 0 8px;
    border: 1px solid rgba(113,16,62,0.3);
}

/* Modal inner content */
.slide-modal-content {
    padding: 30px;
    overflow-y: auto;
    height: 100%;
}
/* Close X button */
.modal-close-btn {
    position: absolute;
    top: 10px;
    right: 16px;
    border: none;
    background: transparent;
    color: #fff;
    font-size: 26px;
    line-height: 1;
    cursor: pointer;
    z-index: 2;
}

/* Optional hover */
.modal-close-btn:hover {
    color: #ffdde9;
}


</style>


<script>
document.getElementById("openRegister").addEventListener("click", function () {
    document.getElementById("registerModal").classList.add("open");
});

document.addEventListener('DOMContentLoaded', function () {
    const registerModal = document.getElementById('registerModal');
    const closeBtn      = document.getElementById('closeRegisterModal');
    const form          = document.getElementById('registerForm');
    const btn           = document.getElementById('registerBtn');
    const spinner       = document.getElementById('registerSpinner');
    const btnText       = document.getElementById('registerBtnText');

    // Close on X
    closeBtn.addEventListener('click', function () {
        registerModal.classList.remove('open');
    });

    // Close on click outside (backdrop)
    registerModal.addEventListener('click', function (e) {
        if (e.target === registerModal) {
            registerModal.classList.remove('open');
        }
    });

    // On submit: show spinner + text changes
    form.addEventListener('submit', function (e) {
        // let the normal submit happen, but change UI immediately
        btn.disabled = true;
        spinner.classList.remove('d-none');
        btnText.textContent = 'Validating…';

        // If you want to show "Sending your data…" after a short delay:
        setTimeout(function () {
            btnText.textContent = 'Sending your data…';
        }, 800); // adjust timing if needed
    });
});


</script>




<style>
    .scrolling-wrapper {
  overflow: hidden;
  position: relative;
  width: 100%;
}

.scrolling-content {
  display: flex;
  gap: 20px;
  animation: scroll-left 30s linear infinite;
}

.scrolling-content .item {
  min-width: 250px; /* adjust card width */
}

@keyframes scroll-left {
  0%   { transform: translateX(100%); }
  100% { transform: translateX(-100%); }
}

</style>
<div class="section trending">
  <div class="container">
    <div class="row">
     <div class="section-heading text-center my-5">
  <h6 class="text-uppercase fw-bold text-primary mb-2 animate-subtitle">
    <i class="fa fa-tags me-2"></i> Categories
  </h6>
  <h2 class="fw-bold display-5 fancy-title">
    Find Job by <span class="text-gradient">Category</span>
  </h2>
  <div class="heading-underline mx-auto mt-3"></div>
</div>
   
    </div>

    <div class="container my-5">
  <div class="row g-4">

    <!-- Support Workers -->
   
    <div class="col-md-4 col-lg-3">
       <a href="/swjobs">
      <div class="category-card shadow-sm">
        <i class="fa fa-users fa-2x mb-3 text-primary"></i>
        <h6 class="fw-bold">Support Workers</h6>
      </div>
        </a>
    </div>
  

    <!-- Senior Support Workers -->
       
    <div class="col-md-4 col-lg-3">
       <a href="/sswjobs">
      <div class="category-card shadow-sm">
        <i class="fa fa-user-shield fa-2x mb-3 text-success"></i>
        <h6 class="fw-bold">Senior Support Workers</h6>
      </div>
          </a>
    </div>



    <!-- Service Managers -->
     
    <div class="col-md-4 col-lg-3">
         <a href="/smjobs" >
      <div class="category-card shadow-sm">
        <i class="fa fa-briefcase fa-2x mb-3 text-info"></i>
        <h6 class="fw-bold">Service Managers</h6>
      </div>
       </a>
    </div>
       

    <!-- Operations Managers -->
       
    <div class="col-md-4 col-lg-3">
       <a href="/omjobs">
      <div class="category-card shadow-sm">
        <i class="fa fa-cogs fa-2x mb-3 text-warning"></i>
        <h6 class="fw-bold">Operations Managers</h6>
      </div>
          </a>
    </div>


    <!-- Social Workers -->
      
    <div class="col-md-4 col-lg-3">
        <a href="/socialwjobs" >
      <div class="category-card shadow-sm">
        <i class="fa fa-hand-holding-heart fa-2x mb-3 text-danger"></i>
        <h6 class="fw-bold">Social Workers</h6>
      </div>
         </a>
    </div>
 


    <!-- Administration Officers -->
       
    <div class="col-md-4 col-lg-3">
       <a href="/amjobs">
      <div class="category-card shadow-sm">
        <i class="fa fa-file-alt fa-2x mb-3 text-secondary"></i>
        <h6 class="fw-bold">Administration Officers</h6>
      </div>
         </a>
    </div>
     

    <!-- Nurses -->
      
    <div class="col-md-4 col-lg-3">
        <a href="/nursesjobs">
      <div class="category-card shadow-sm">
        <i class="fa fa-stethoscope fa-2x mb-3 text-primary"></i>
        <h6 class="fw-bold">Nurses</h6>
      </div>
         </a>
    </div>
     


    <!-- Team Leaders -->
    
    <div class="col-md-4 col-lg-3">
          <a href="/tmjobs" >
      <div class="category-card shadow-sm">
        <i class="fa fa-users-cog fa-2x mb-3 text-success"></i>
        <h6 class="fw-bold">Team Leaders</h6>
      </div>
       </a>
    </div>
       


    <!-- Business Managers -->
     
    <div class="col-md-4 col-lg-3">
         <a href="/bmjobs" >
      <div class="category-card shadow-sm">
        <i class="fa fa-chart-line fa-2x mb-3 text-dark"></i>
        <h6 class="fw-bold">Business Managers</h6>
      </div>
         </a>
    </div>
     


  </div>
</div>

<!-- Custom CSS -->
<style>
.category-card {
  background: white;
  border-radius: 16px;
  padding: 30px 20px;
  text-align: center;
  transition: all 0.3s ease;
  cursor: pointer;
  color: #333; /* default text color */
}

.category-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 12px 24px rgba(0,0,0,0.15);
  background: rgb(113, 16, 62);
  color: white; /* base text color */
}

/* Ensure headings and paragraphs inside also turn white */
.category-card:hover h6,
.category-card:hover p,
.category-card:hover i {
  color: white !important;
}

.category-card i {
  transition: transform 0.3s ease;
}

.category-card:hover i {
  transform: scale(1.2);
}

   /* Gradient text for emphasis */
  .text-gradient {
    background: linear-gradient(90deg, #007bff, #00c6ff);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  /* Decorative underline */
  .heading-underline {
    width: 80px;
    height: 4px;
    background: linear-gradient(90deg, #007bff, #00c6ff);
    border-radius: 2px;
  }

  /* Subtitle animation */
  .animate-subtitle {
    letter-spacing: 2px;
    animation: fadeInUp 1s ease;
  }

  /* Title animation */
  .fancy-title {
    animation: fadeInDown 1s ease;
  }

  @keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
  }

  @keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
  }
</style>

    

<!-- Scrolling wrapper -->
{{-- <div class="scrolling-wrapper">
    <div class="scrolling-content">
        <div class="item">
            <div class="thumb">
                <a href="job-details.html"><i class="fa fa-laptop text-primary" style="font-size: 48px;"></i></a>
            </div>
            <div class="down-content">
                <span class="category">Technology</span>
                <h4>Software Engineer</h4>
                <a href="job-details.html"><i class="fa fa-briefcase"></i></a>
            </div>
        </div>

        <div class="item">
            <div class="thumb">
                <a href="job-details.html"><i class="fa fa-bullhorn text-primary" style="font-size: 48px;"></i></a>
            </div>
            <div class="down-content">
                <span class="category">Marketing</span>
                <h4>Marketing Specialist</h4>
                <a href="job-details.html"><i class="fa fa-briefcase"></i></a>
            </div>
        </div>

        <div class="item">
            <div class="thumb">
                <a href="job-details.html"><i class="fa fa-tasks text-primary" style="font-size: 48px;"></i></a>
            </div>
            <div class="down-content">
                <span class="category">Management</span>
                <h4>Project Manager</h4>
                <a href="job-details.html"><i class="fa fa-briefcase"></i></a>
            </div>
        </div>

        <div class="item">
            <div class="thumb">
                <a href="job-details.html"><i class="fa fa-chart-line text-primary" style="font-size: 48px;"></i></a>
            </div>
            <div class="down-content">
                <span class="category">Analytics</span>
                <h4>Data Analyst</h4>
                <a href="job-details.html"><i class="fa fa-briefcase"></i></a>
            </div>
        </div>
    </div>
</div> --}}
  </div>
</div>










{{-- 
  <div class="section categories">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 text-center">
        <div class="section-heading">
          <h6>Categories</h6>
          <h2>Top Job Categories</h2>
        </div>
      </div>

      <!-- Support Worker -->
      <div class="col-lg col-sm-6 col-xs-12">
        <div class="item">
          <h4>Support Worker</h4>
          <div class="thumb">
            <a href="job-details.html"><img src="assets/images/categories-01.jpg" alt="Support Worker"></a>
          </div>
        </div>
      </div>

      <!-- Allied Health -->
      <div class="col-lg col-sm-6 col-xs-12">
        <div class="item">
          <h4>Allied Health</h4>
          <div class="thumb">
            <a href="job-details.html"><img src="assets/images/categories-02.jpg" alt="Allied Health"></a>
          </div>
        </div>
      </div>

      <!-- Nursing -->
      <div class="col-lg col-sm-6 col-xs-12">
        <div class="item">
          <h4>Nursing</h4>
          <div class="thumb">
            <a href="job-details.html"><img src="assets/images/categories-03.jpg" alt="Nursing"></a>
          </div>
        </div>
      </div>

      <!-- Therapy Services -->
      <div class="col-lg col-sm-6 col-xs-12">
        <div class="item">
          <h4>Therapy Services</h4>
          <div class="thumb">
            <a href="job-details.html"><img src="assets/images/categories-04.jpg" alt="Therapy Services"></a>
          </div>
        </div>
      </div>

      <!-- Administration -->
      <div class="col-lg col-sm-6 col-xs-12">
        <div class="item">
          <h4>Administration</h4>
          <div class="thumb">
            <a href="job-details.html"><img src="assets/images/categories-05.jpg" alt="Administration"></a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div> --}}

  

  <footer class="footer text-light pt-5 pb-4">
  <div class="container">
    <div class="row">

      <!-- Job Seekers -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="mb-3 text-light">Job Seekers</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-light">Job search</a></li>
          <li><a href="#" class="text-light">Profile</a></li>
            <li><a href="#" class="text-light">Upload resume</a></li>
            <li><a href="#" class="text-light">Job alerts</a></li>
            <li><a href="#" class="text-light">CV advice</a></li>
            <li><a href="#" class="text-light">Interview tips</a></li>
            <li><a href="#" class="text-light">Career advice</a></li>
            <li><a href="#" class="text-light">Browse companies</a></li>
            <li><a href="#" class="text-light">Browse recruiters</a></li>   
        </ul>
      </div>

      <!-- Employers -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="mb-3 text-light">Employers</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-light">Register for free</a></li>
          <li><a href="#" class="text-light">Post a job ad</a></li>
            <li><a href="#" class="text-light">Search resumes</a></li>
            <li><a href="#" class="text-light">Employer login</a></li>
            <li><a href="#" class="text-light">Advertise with us</a></li>
            <li><a href="#" class="text-light">Recruiter directory</a></li>
            <li><a href="#" class="text-light">Pricing Table</a></li>
            <li><a href="#" class="text-light">Careers</a></li> 
            <li><a href="#" class="text-light">Blog</a></li>        
        </ul>
      </div>

      <!-- About Us -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="mb-3 text-light">About Us</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-light">About CareerJobs</a></li>
        <li><a href="#" class="text-light">Media centre</a></li>
          <li><a href="#" class="text-light">Careers</a></li>
            <li><a href="#" class="text-light">Blog</a></li>
            <li><a href="#" class="text-light">Reviews</a></li>
        </ul>
      </div>

      <!-- Contact -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="mb-3 text-light">Contact</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-light">Help centre</a></li>
          <li><a href="#" class="text-light">Contact us</a></li>
            <li><a href="#" class="text-light">Partnerships</a></li>
            <li><a href="#" class="text-light">Advertising</a></li>
            <li><a href="#" class="text-light">Sitemap</a></li>
            <li><a href="#" class="text-light">Terms &amp; conditions</a></li>
            <li><a href="#" class="text-light">Privacy policy</a></li>
            <li><a href="#" class="text-light">Cookie policy</a></li>
            <li><a href="#" class="text-light">Accessibility statement</a></li>
        </ul>
      </div>

    </div>

    <!-- Footer bottom -->
     <div class="container">
      <div class="col-lg-12">
        <p>Copyright © 2025 CareerJobs. All rights reserved. &nbsp;&nbsp; <a rel="nofollow" href="#" target="_blank"></a></p>
      </div>
    </div>
</footer>




  <!-- Scripts -->
  <!-- Bootstrap core JavaScript -->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
  <script src="assets/js/isotope.min.js"></script>
  <script src="assets/js/owl-carousel.js"></script>
  <script src="assets/js/counter.js"></script>
  <script src="assets/js/custom.js"></script>

  <script>
    
function initSuburbAutocomplete() {
    const input = document.getElementById('location');
     if (!input) {
    console.warn('No #location input found');
    return;
  }

    // Australia bounds (rough box) to help relevance
    const ausBounds = new google.maps.LatLngBounds(
      new google.maps.LatLng(-44.0, 112.0), // SW
      new google.maps.LatLng(-10.0, 154.0)  // NE
    );

    const autocomplete = new google.maps.places.Autocomplete(input, {
      // Regions returns localities, sublocalities, etc.
      types: ['(regions)'],
      componentRestrictions: { country: 'au' },
      fields: ['address_components', 'formatted_address', 'name', 'geometry'],
      bounds: ausBounds,
      strictBounds: true
    });

    autocomplete.addListener('place_changed', () => {
      const place = autocomplete.getPlace();
      console.log('Selected suburb:', place.formatted_address);
      if (!place || !place.address_components) return;

      // Extract suburb (locality or sublocality_level_1), state, postcode
      let suburb = '';
      let state = '';
      let postcode = '';

      place.address_components.forEach(c => {
        const types = c.types || [];
        if (types.includes('locality')) suburb = c.long_name;
        if (types.includes('sublocality') || types.includes('sublocality_level_1')) {
          // Some suburbs are provided as sublocality
          suburb = suburb || c.long_name;
        }
        if (types.includes('administrative_area_level_1')) state = c.short_name; // e.g., QLD, NSW
        if (types.includes('postal_code')) postcode = c.long_name;
      });

      // Accept only if we got a suburb-like value
      if (suburb) {
        const display = `${suburb}${state ? ', ' + state : ''}${postcode ? ' ' + postcode : ''}`;
        input.value = display;
        input.setCustomValidity('');
      } else {
        // Not a suburb: prompt user to pick a suburb
        input.setCustomValidity('Please select a suburb in Australia (not a street or business).');
        input.reportValidity();
      }
    });

    // Optional: prevent form submit on Enter before a place is selected
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') e.preventDefault();
    });
  }

  </script>

  </body>
</html>