<!-- Expired Jobs Offcanvas -->
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="jobOffcanvas-expired">
    <div class="offcanvas-header bg-gradient-danger text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-times-circle me-2"></i> Expired Jobs
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h6 class="fw-bold mb-3 text-danger">
                    <i class="fa fa-list me-2"></i> Job Listings
                </h6>

                @if($expiredJobs->isEmpty())
                    <div class="text-center py-5">
                        <i class="fa fa-info-circle fa-3x text-muted mb-3"></i>
                        <h5 class="fw-bold text-secondary">No Expired Jobs</h5>
                        <p class="text-muted mb-4">You don’t have any expired job ads yet.</p>
                        <a href="javascript:void(0)"
                           class="btn btn-danger"
                           data-bs-toggle="offcanvas"
                           data-bs-target="#jobFormCanvasUnique">
                            <i class="fa fa-plus me-2"></i> Post a Job Ad
                        </a>

                    </div>
                @else
                    <div class="table-responsive">
                        @include('components.expiredjobs', ['jobs' => $expiredJobs])
                    </div>
                @endif

            </div>
        </div>
    </div>
</div>