<script src="https://js.stripe.com/v3/"></script>
<meta name="csrf-token" content="{{ csrf_token() }}">
<table class="table table-striped">
    <thead>
    <tr>
        <th>Job ID</th>
        <th>Category</th>
        <th>Date Published</th>
        <th>Expiring In</th>
        <th>Expiry Date</th>
        <th>Status</th>
     
    </tr>
    </thead>
    <tbody>

@foreach($jobs as $job)
    <tr style="cursor:pointer;"
        onclick="openactiveadDetailsCanvasc({{ json_encode($job) }})">
        <td>{{ $job->id }}</td>
        <td>{{ $job->category }}</td>
        <td>{{ $job->created_at->format('d M Y') }}</td>
        <td>{{ round(abs(\Carbon\Carbon::parse($job->expiry_date)->diffInDays($job->created_at, false))) }} days</td>
        <td>{{ $job->expiry_date}}</td>
        <td>
            @switch($job->status)
                @case('active')
                    <span class="badge bg-primary">Active</span>
                    @break

                @case('open')
                    <span class="badge bg-success">Open</span>
                    @break

                @case('expired')
                    <span class="badge bg-danger">Expired</span>
                    @break

                @case('closed')
                    <span class="badge bg-secondary">Closed</span>
                    @break

                @default
                    <span class="badge bg-dark">{{ ucfirst($job->status) }}</span>
            @endswitch
        </td>
    </tr>
@endforeach

    </tbody>
</table>



 {{-- Off-Canvas for displaycing Ad Details --}}
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="openadDetailsCanvasc">
    <div class="offcanvas-header bg-gradient-primary text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-info-circle me-2"></i> Ad Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">

        <div class="row mb-3 align-items-center justify-content-between">
    <!-- Left side: Title -->
    <div class="col-auto">
        <h6 class="fw-bold text-primary mb-0">
            <i class="fa fa-list me-2"></i> Job Ad Information
        </h6>
    </div>

    <!-- Right side: Expiry Button -->
    <div class="col-auto">
        <button class="btn btn-outline-danger btn-sm fw-semibold">
            Expiring in: <span id="days_left_displayc">30</span> Days
        </button>
    </div>
</div>


        <div>
            <hr>
        </div>

        <div>
            <row class="mb-4">
                <div class="col">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="offcanvas">
                        <i class="fa fa-arrow-left me-2"></i> Back to Job Listings
                    </button>
                    <!-- Edit Job Ad Button -->
{{-- <button type="button" 
        class="btn btn-primary btn-sm ms-2" 
        onclick="EditAdForm();">
    <i class="fa fa-edit me-2"></i> Edit Job Ad
</button> --}}




<!-- Delete button -->
<button id="deleteBtn" type="button" class="btn btn-danger btn-sm ms-2" onclick="deleteAd()">
  <i class="fa fa-trash me-2"></i> Delete Job Ad
</button>

                    {{-- <button type="button" class="btn btn-success btn-sm ms-2"disabled>
                        <i class="fa fa-check me-2"></i> Publish Job Ad
                    </button> --}}
    <!-- Close Job Ad button -->
{{-- <button id="closeBtn" type="button" class="btn btn-warning btn-sm ms-2" onclick="closeAd()">
  <i class="fa fa-times me-2"></i> Close Job Ad
</button> --}}

                    {{-- <button type="button" class="btn btn-info btn-sm ms-2" onclick="cOpenExtendedPeriodPanel()">
    <i class="fa fa-refresh me-2"></i> Renew Job Ad
</button> --}}
                    {{-- <button type="button" class="btn btn-dark btn-sm ms-2" disabled>
                        <i class="fa fa-download me-2"></i> Export Applicants
                    </button> --}}
                </div>
            </row>
        </div>

        <br>

        <div class="row g-4">
            <!-- Ad Type -->
<div class="col-md-12">
    <div class="card" 
         style="border: none; border-radius: 16px; 
                background: linear-gradient(135deg, #f0f8ff, #e6f7ff); 
                box-shadow: 0 8px 20px rgba(0,0,0,0.15); 
                transition: all 0.4s ease; overflow: hidden;">
        <div class="card-body d-flex align-items-center justify-content-between" 
             style="displayc: flex; align-items: center; justify-content: space-between; padding: 20px;">
            
            <!-- Left side: Icon + Title -->
            <div style="displayc: flex; align-items: center; gap: 14px;">
                
                <div>
                    <h5 style="margin: 0; font-weight: 700; 
                               background: linear-gradient(90deg, #007bff, #00c6ff); 
                               -webkit-background-clip: text; 
                               -webkit-text-fill-color: transparent;">
                        Ad Type
                    </h5>
                    <p id="ad_type_displayc" 
                       style="margin: 0; font-size: 1.1rem; font-weight: 600; color: #333;">
                        Basic
                    </p>
                </div>
            </div>

            <!-- Right side: Status badge -->
            <span id="status_displayc" 
                 style="background: linear-gradient(90deg, #36c95f, #2f8f4e); 
                         color: #fff; font-weight: 600; 
                         padding: 8px 16px; border-radius: 20px; 
                         box-shadow: 0 4px 12px rgba(47,143,78,0.4); 
                         font-size: 0.9rem; letter-spacing: 0.5px;">
        Status??
            </span>
        </div>
    </div>
</div>



            <!-- Job Title -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Title</h5>
                        <p class="card-text" id="job_title_displayc">Software Engineer</p>
                    </div>
                </div>
            </div>

            <!-- Company -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Company</h5>
                        <p class="card-text" id="company_displayc">Tech Solutions Inc.</p>
                    </div>
                </div>
            </div>

            <!-- Category -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Category</h5>
                        <p class="card-text" id="category_displayc">Information Technology</p>
                    </div>
                </div>
            </div>

            <!-- Location -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Location</h5>
                        <p class="card-text" id="location_displayc">New York, NY</p>
                    </div>
                </div>
            </div>

            <!-- Workplace -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Workplace</h5>
                        <p class="card-text" id="workplace_displayc">Remote</p>
                    </div>
                </div>
            </div>

            <!-- Type of Work -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Type of Work</h5>
                        <p class="card-text" id="work_type_displayc">Full-time</p>
                    </div>
                </div>
            </div>

            <!-- Pay Type -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Type</h5>
                        <p class="card-text" id="pay_type_displayc">Hourly</p>
                    </div>
                </div>
            </div>

            <!-- Pay Min -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Min</h5>
                        <p class="card-text" id="pay_min_displayc">$25</p>
                    </div>
                </div>
            </div>

            <!-- Pay Max -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Max</h5>
                        <p class="card-text" id="pay_max_displayc">$40</p>
                    </div>
                </div>
            </div>

            <!-- Pay Visibility -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Visibility</h5>
                        <p class="card-text" id="pay_visibility_displayc">Visible</p>
                    </div>
                </div>
            </div>

            <!-- Job Description -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Description</h5>
                       <div id="description_displayc"></div>
                    </div>
                </div>
            </div>

            <!-- Job Summary -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Summary</h5>
                         <div id="summary_displayc"></div>
                    </div>
                </div>
            </div>

        <!-- Logo -->
<div class="col-md-6" id="logo_field_displayc">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <h5 class="card-title">Logo</h5>
            <img id="logo_displayc" src="" alt="Company Logo" 
                 style="max-width: 150px; height: auto; border-radius: 8px;">
        </div>
    </div>
</div>

<!-- Overview -->
<div class="col-md-6" id="overview_field_displayc">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Overview</h5>
            <p class="card-text" id="overview_displayc"></p>
        </div>
    </div>
</div>

<!-- Social Media -->
<div class="col-md-6" id="social_media_field_displayc">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Social Media</h5>
            <p class="card-text" id="social_media_displayc"></p>
        </div>
    </div>
</div>

<!-- Video -->
<div class="col-md-6" id="video_field_displayc">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Video</h5>
            <a id="video_displayc" href="#" target="_blank">Watch Video</a>
        </div>
    </div>
</div>


            <!-- Questions -->
     <div class="col-md-12">
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title">Questions to Candidates</h5>
      <div id="questionsWrapperc" class="row">
        <!-- Questions will be injected here -->
      </div>
    </div>
  </div>
</div>

        </div>

        <!-- Close Button -->
        <div class="mt-4 text-end">
            <button type="button" class="btn btn-danger" data-bs-dismiss="offcanvas">Close</button>
        </div>
    </div>
</div>


<!-- Edit Job Ad Offcanvas -->
{{-- <div class="offcanvas offcanvas-top" tabindex="-1" id="editAdCanvas" aria-labelledby="editAdCanvasLabel"
     style="height: 100vh; background: linear-gradient(135deg, white); border-radius: 0 0 20px 20px; box-shadow: 0 8px 30px rgba(0,0,0,0.2);">
  <div class="offcanvas-header border-bottom" style="background: rgb(113,16,62); color: #fff;">
    <h5 class="offcanvas-title fw-bold" id="editAdCanvasLabel">
      <i class="fa fa-edit me-2"></i> Edit Job Ad
    </h5>
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <form id="editAdForm" class="row g-3">
      
      <!-- Job Title -->
   <div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-briefcase me-2 text-primary"></i> Job Title
  </label>
  <div class="p-3 bg-light border-start border-4 border-primary rounded shadow-sm fw-bold text-dark" 
       id="edit_job_title"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-building me-2 text-primary"></i> Company
  </label>
  <div class="p-3 bg-light border-start border-4 border-success rounded shadow-sm fw-bold text-dark" 
       id="edit_company"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-tags me-2 text-primary"></i> Category
  </label>
  <div class="p-3 bg-light border-start border-4 border-warning rounded shadow-sm fw-bold text-dark" 
       id="edit_category"></div>
</div>

<div class="col-md-6 mb-3">
  <label class="form-label fw-semibold">
    <i class="fa fa-map-marker-alt me-2 text-primary"></i> Location
  </label>
  <div class="p-3 bg-light border-start border-4 border-danger rounded shadow-sm fw-bold text-dark" 
       id="edit_location"></div>
</div>

<div class="col-12">
        <h6 class="fw-bold text-primary mb-4">
          <i class="fa fa-info-circle me-2"></i> You can edit the job ad details below
        </h6>
        </div>

      <!-- Workplace -->
   <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-laptop-house me-2 text-primary"></i> Workplace
  </label>
  <select class="form-select shadow-sm" id="edit_workplace">
    <option value="">Select Workplace</option>
    <option value="On-site">On-site</option>
    <option value="Remote">Remote</option>
    <option value="Hybrid">Hybrid</option>
  </select>
</div>


      <!-- Work Type -->
     <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-clock me-2 text-primary"></i> Work Type
  </label>
  <select class="form-select shadow-sm" id="edit_work_type">
    <option value="">Select Work Type</option>
    <option value="Full-time">Full-time</option>
    <option value="Part-time">Part-time</option>
    <option value="Casual">Casual</option>
    <option value="Contract">Contract</option>
    <option value="Internship">Internship</option>
    <option value="Temporary">Temporary</option>
  </select>
</div>


      <!-- Pay Type -->
      <div class="col-md-6">
  <label class="form-label fw-semibold">
    <i class="fa fa-money-bill me-2 text-primary"></i> Pay Type
  </label>
  <select class="form-select shadow-sm" id="edit_pay_type">
    <option value="">Select Pay Type</option>
    <option value="Hourly">Hourly</option>
    <option value="Salary">Salary</option>
    <option value="Contract">Contract</option>
    <option value="Commission">Commission</option>
  </select>
</div>


      <!-- Pay Range -->
      <div class="col-md-3">
        <label class="form-label fw-semibold">Min Pay</label>
        <input type="number" class="form-control shadow-sm" id="edit_pay_min">
      </div>
      <div class="col-md-3">
        <label class="form-label fw-semibold">Max Pay</label>
        <input type="number" class="form-control shadow-sm" id="edit_pay_max">
      </div>

      <!-- Description -->
<div class="col-12">
  <label class="form-label fw-semibold">
    <i class="fa fa-align-left me-2 text-primary"></i> Description
  </label>
  <textarea class="form-control shadow-sm" id="edit_description" rows="6"></textarea>
</div>

<!-- Summary -->
<div class="col-12">
  <label class="form-label fw-semibold">
    <i class="fa fa-sticky-note me-2 text-primary"></i> Summary
  </label>
  <textarea class="form-control shadow-sm" id="edit_summary" rows="4"></textarea>
</div>

        <!-- Overview -->   
        <div class="col-12" id="overview_field_edit">
        <label class="form-label fw-semibold"><i class="fa fa-info
-circle me-2 text-primary"></i> Overview</label>
        <textarea class="form-control shadow-sm" id="edit_overview" rows="4"></textarea>
        </div>



      <!-- Logo -->
      <div class="col-md-6" id="logo_field_edit">
        <label class="form-label fw-semibold"><i class="fa fa-image me-2 text-primary"></i> Logo</label>
        <input type="text" class="form-control shadow-sm" id="edit_logo" placeholder="Logo URL">
      </div>

      <!-- Social Media -->
      <div class="col-md-6 " id="social_media_field_edit">
        <label class="form-label fw-semibold"><i class="fa fa-share-alt me-2 text-primary"></i> Social Media</label>
        <input type="text" class="form-control shadow-sm" id="edit_social_media">
      </div>

      <!-- Video -->
      <div class="col-md-6" id="video_field_edit">
        <label class="form-label fw-semibold"><i class="fa fa-video me-2 text-primary"></i> Video</label>
        <input type="text" class="form-control shadow-sm" id="edit_video" placeholder="Video URL">
      </div>
     

      <!-- Save Button -->
      <div class="col-12 text-end mt-4">
<button id="saveBtn" type="button" class="btn btn-outline-success px-4 shadow-sm" onclick="saveAdChanges()">
  <i class="fa fa-save me-2"></i> Save Changes
</button>

      </div>
    </form>
  </div>
</div> --}}


<script>

function openactiveadDetailsCanvasc(ad) {
    console.log(ad);

    sessionStorage.setItem('selectedAd', JSON.stringify(ad));

    console.log("Ad data saved to sessionStorage.", ad);    



    // Populate the fields with the ad details
    document.getElementById('status_displayc').innerText = ad.status || 'N/A';
    document.getElementById('ad_type_displayc').innerText = ad.ad_type || 'N/A';
    document.getElementById('job_title_displayc').innerText = ad.job_title || 'N/A';
    document.getElementById('company_displayc').innerText = ad.company || 'N/A';
    document.getElementById('category_displayc').innerText = ad.category || 'N/A';
    document.getElementById('location_displayc').innerText = ad.location || 'N/A';
    document.getElementById('workplace_displayc').innerText = ad.workplace || 'N/A';
    document.getElementById('work_type_displayc').innerText = ad.work_type || 'N/A';
    document.getElementById('pay_type_displayc').innerText = ad.pay_type || 'N/A';
    document.getElementById('pay_min_displayc').innerText = ad.pay_min !== undefined ? `$${ad.pay_min}` : 'N/A';
    document.getElementById('pay_max_displayc').innerText = ad.pay_max !== undefined ? `$${ad.pay_max}` : 'N/A';
    document.getElementById('pay_visibility_displayc').innerText = ad.pay_visibility || 'N/A';
    document.getElementById('description_displayc').innerHTML = ad.description_html || 'N/A';
    document.getElementById('summary_displayc').innerHTML = ad.summary_html || 'N/A';
  

    // --- Conditional displayc based on ad_type ---
    const logoField = document.getElementById('logo_field_displayc');
    const overviewField = document.getElementById('overview_field_displayc');
    const socialField = document.getElementById('social_media_field_displayc');
    const videoField = document.getElementById('video_field_displayc');
 

    // Hide all by default
    logoField.style.displayc = 'none';
    overviewField.style.displayc = 'none';
    socialField.style.displayc = 'none';
    videoField.style.displayc = 'none';

    if (ad.ad_type === "basic") {
        // Show only overview + social
        // overviewField.style.displayc = 'block';
        // socialField.style.displayc = 'block';
    } else if (ad.ad_type === "premium") {
        // Show logo, overview, social (hide video)
        logoField.style.displayc = 'block';
        overviewField.style.displayc = 'block';
        socialField.style.displayc = 'block';
    } else if (ad.ad_type === "platinum") {
        // Show everything
        logoField.style.displayc = 'block';
        overviewField.style.displayc = 'block';
        socialField.style.displayc = 'block';
        videoField.style.displayc = 'block';
    }

    // --- Populate values ---
    // Logo (image)
    if (ad.logo) {
        const logoImg = document.getElementById('logo_displayc');
        logoImg.src = ad.logo;
        logoImg.alt = ad.company || "Company Logo";
    }

    // Overview
    if (ad.overview) {
        document.getElementById('overview_displayc').innerText = ad.overview;
    }

    // Social Media
    if (ad.social_media) {
        document.getElementById('social_media_displayc').innerText = ad.social_media;
    }

    // Video
    if (ad.video) {
        document.getElementById('video_displayc').href = ad.video;
        document.getElementById('video_displayc').innerText = "Watch Video";
    }

    // --- Days left until expiry ---
    const today = new Date();
    const expiryDate = new Date(ad.expiry_date);
    const timeDiff = expiryDate - today;
    const daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));
    document.getElementById('days_left_displayc').innerText = daysLeft > 0 ? daysLeft : '0';

      // --- Populate Questions ---// --- Populate questions ---
const questionsWrapper = document.getElementById('questionsWrapperc');
questionsWrapper.innerHTML = ''; // Clear previous questions

const questions = ad.questions || [];

// Split into two roughly equal halves
const half = Math.ceil(questions.length / 2);
const col1 = questions.slice(0, half);
const col2 = questions.slice(half);

// Create column containers
const col1Div = document.createElement('div');
col1Div.className = 'col-md-6';
const col2Div = document.createElement('div');
col2Div.className = 'col-md-6';

// Add questions with ticks
col1.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col1Div.appendChild(p);
});

col2.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col2Div.appendChild(p);
});

// Append both columns to wrapper
questionsWrapper.appendChild(col1Div);
questionsWrapper.appendChild(col2Div);



    // --- Show the ad details canvas ---
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('openadDetailsCanvasc'));
    offcanvas.show();
}

function closeOtherOffcanvas() {
    // Close Ad Details offcanvas if open
    const openadDetailsCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('openadDetailsCanvas'));
      if (openadDetailsCanvas) openadDetailsCanvas.hide();

    // Close Active Jobs offcanvas if open
    const jobOffcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('jobOffcanvas-active'));
  
    if (jobOffcanvas) jobOffcanvas.hide();
}



// Function to open the Edit Ad Form with pre-filled data
// function activeJobsEditAdForm(ad = null) {
//     closeOtherOffcanvas();

//     // If no ad object passed in, try to retrieve from sessionStorage
//     if (!ad) { 
//         const adData = sessionStorage.getItem('selectedAd');
//         ad = adData ? JSON.parse(adData) : null;
//         console.log("Retrieved ad data from sessionStorage:", ad);
//     }

//     if (!ad) {
//         console.error("No ad data available for editing.");
//         return;
//     }

//     // Populate read-only displayc fields
//     document.getElementById('edit_job_title').textContent = ad.job_title   ?? '';
//     document.getElementById('edit_company').textContent   = ad.company     ?? '';
//     document.getElementById('edit_category').textContent  = ad.category    ?? '';
//     document.getElementById('edit_location').textContent  = ad.location    ?? '';

//     // Populate editable fields
//     document.getElementById('edit_workplace').value    = ad.workplace   ?? '';
//     document.getElementById('edit_work_type').value    = ad.work_type   ?? '';
//     document.getElementById('edit_pay_type').value     = ad.pay_type    ?? '';
//     document.getElementById('edit_pay_min').value      = ad.pay_min     ?? '';
//     document.getElementById('edit_pay_max').value      = ad.pay_max     ?? '';
//     document.getElementById('edit_description').value  = ad.description ?? '';
//     document.getElementById('edit_summary').value      = ad.summary     ?? '';

//     // Handle expiry date safely
//     // if (ad.expiry_date) {
//     //     try {
//     //         const dateOnly = ad.expiry_date.includes('T') 
//     //             ? ad.expiry_date.split('T')[0] 
//     //             : ad.expiry_date;
//     //         document.getElementById('edit_expiry_date').value = dateOnly;
//     //     } catch (e) {
//     //         console.warn("Invalid expiry_date format:", ad.expiry_date);
//     //         document.getElementById('edit_expiry_date').value = '';
//     //     }
//     // } else {
//     //     document.getElementById('edit_expiry_date').value = '';
//     // }

//     // === Field visibility logic based on ad_type ===
//     const logoFieldedit     = document.getElementById('logo_field_edit');
//     const overviewFieldedit = document.getElementById('overview_field_edit');
//     const socialFieldedit   = document.getElementById('social_media_field_edit');
//     const videoFieldedit    = document.getElementById('video_field_edit');

//     // Hide all by default
//     [logoFieldedit, overviewFieldedit, socialFieldedit, videoFieldedit].forEach(el => el.style.displayc = 'none');

//     // Hide advanced editable fields by default
//     document.getElementById('edit_logo').closest('.col-md-6').style.displayc         = 'none';
//     document.getElementById('edit_social_media').closest('.col-md-6').style.displayc = 'none';
//     document.getElementById('edit_video').closest('.col-md-6').style.displayc        = 'none';
//     document.getElementById('edit_summary').closest('.col-12').style.displayc        = 'none';

//     if (ad.ad_type === "basic") {
//         // Show only summary
//         document.getElementById('edit_summary').closest('.col-12').style.displayc = 'block';
//     } 
//     else if (ad.ad_type === "premium") {
//         // Show logo, overview, social (hide video)
//         logoFieldedit.style.displayc     = 'block';
//         overviewFieldedit.style.displayc = 'block';
//         socialFieldedit.style.displayc   = 'block';

//         document.getElementById('edit_logo').closest('.col-md-6').style.displayc         = 'block';
//         document.getElementById('edit_summary').closest('.col-12').style.displayc        = 'block';
//         document.getElementById('edit_social_media').closest('.col-md-6').style.displayc = 'block';
//     } 
//     else if (ad.ad_type === "platinum") {
//         // Show everything
//         logoFieldedit.style.displayc     = 'block';
//         overviewFieldedit.style.displayc = 'block';
//         socialFieldedit.style.displayc   = 'block';
//         videoFieldedit.style.displayc    = 'block';

//         document.getElementById('edit_logo').closest('.col-md-6').style.displayc         = 'block';
//         document.getElementById('edit_summary').closest('.col-12').style.displayc        = 'block';
//         document.getElementById('edit_social_media').closest('.col-md-6').style.displayc = 'block';
//         document.getElementById('edit_video').closest('.col-md-6').style.displayc        = 'block';
//     }

//     // Show offcanvas
//     const offcanvas = new bootstrap.Offcanvas(document.getElementById('editAdCanvas'));
//     offcanvas.show();
// }

// function EditAdForm(ad = null) {

//     console.log("Opening Edit Ad Form...", ad);
//     // closeOtherOffcanvas();

//     if (!ad) {
//         const adData = sessionStorage.getItem('selectedAd');
//         ad = adData ? JSON.parse(adData) : null;
//     }
//     if (!ad) return;

//     // Populate fields
//     //     // Populate read-only displayc fields
//     document.getElementById('edit_job_title').textContent = ad.job_title   ?? '';
//     document.getElementById('edit_company').textContent   = ad.company     ?? '';
//     document.getElementById('edit_category').textContent  = ad.category    ?? '';
//     document.getElementById('edit_location').textContent  = ad.location    ?? '';
//     //     // Populate editable fields
//     document.getElementById('edit_workplace').value    = ad.workplace   ?? '';
//     document.getElementById('edit_work_type').value    = ad.work_type   ?? '';
//     document.getElementById('edit_pay_type').value     = ad.pay_type    ?? '';
//     document.getElementById('edit_pay_min').value      = ad.pay_min     ?? '';
//     document.getElementById('edit_pay_max').value      = ad.pay_max     ?? '';
//     document.getElementById('edit_description').value  = ad.description ?? '';
//     document.getElementById('edit_overview').value      = ad.overview     ?? '';
//     document.getElementById('edit_summary').value      = ad.summary     ?? '';
//     document.getElementById('edit_logo').value          = ad.logo         ?? '';
//     document.getElementById('edit_social_media').value  = ad.social_media ?? '';
//     document.getElementById('edit_video').value         = ad.video        ?? '';

//     // Grab wrapper divs
//     const logoFieldedit     = document.getElementById('logo_field_edit');
//     const overviewFieldedit = document.getElementById('overview_field_edit');
//     const socialFieldedit   = document.getElementById('social_media_field_edit');
//     const videoFieldedit    = document.getElementById('video_field_edit');

//     // Hide all by default
//     [logoFieldedit, overviewFieldedit, socialFieldedit, videoFieldedit].forEach(el => el.style.displayc = 'none');

//     // Show depending on ad_type
//     if (ad.ad_type === "basic") {
//         // overviewFieldedit.style.displayc = 'block';
//         // socialFieldedit.style.displayc   = 'block';
//     } else if (ad.ad_type === "premium") {
//         logoFieldedit.style.displayc     = 'block';
//         overviewFieldedit.style.displayc = 'block';
//         socialFieldedit.style.displayc   = 'block';
//     } else if (ad.ad_type === "platinum") {
//         logoFieldedit.style.displayc     = 'block';
//         overviewFieldedit.style.displayc = 'block';
//         socialFieldedit.style.displayc   = 'block';
//         videoFieldedit.style.displayc    = 'block';
//     }

//     // Show offcanvas
//     const offcanvas = new bootstrap.Offcanvas(document.getElementById('editAdCanvas'));
//     offcanvas.show();
// }





// Function to collect updated data
function saveAdChanges() {
    const saveBtn = document.getElementById('saveBtn');

    // Disable button and show circle spinner inside it
    saveBtn.disabled = true;
    saveBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span> Saving Changes...';

    // Retrieve the selected ad
    const adData = sessionStorage.getItem('selectedAd');
    const originalAd = adData ? JSON.parse(adData) : {};

    const updatedAd = {
        id:            originalAd.id,
        workplace:     document.getElementById('edit_workplace').value.trim(),
        work_type:     document.getElementById('edit_work_type').value.trim(),
        pay_type:      document.getElementById('edit_pay_type').value.trim(),
        pay_min:       parseFloat(document.getElementById('edit_pay_min').value) || null,
        pay_max:       parseFloat(document.getElementById('edit_pay_max').value) || null,
        description:   document.getElementById('edit_description').value.trim(),
        summary:       document.getElementById('edit_summary').value.trim(),
        logo:          document.getElementById('edit_logo').value.trim(),
        social_media:  document.getElementById('edit_social_media').value.trim(),
        video:         document.getElementById('edit_video').value.trim(),
        overview:      document.getElementById('edit_overview').value.trim()
    };

    fetch(`/jobboards/${updatedAd.id}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(updatedAd)
    })
    .then(res => {
        if (!res.ok) throw new Error(`Server error: ${res.status}`);
        return res.json();
    })
    .then(data => {
        Notiflix.Notify.success('Job updated successfully!');
        sessionStorage.setItem('selectedAd', JSON.stringify(updatedAd));

        // Close offcanvas and redirect
        const offcanvasEl = document.getElementById('editAdCanvas');
        const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
        if (offcanvas) offcanvas.hide();
        window.location.href = '/admin/home';
    })
    .catch(err => {
        Notiflix.Notify.failure(`Update failed: ${err.message}`);
    })
    .finally(() => {
        // Restore button state
        saveBtn.disabled = false;
        saveBtn.innerHTML = '<i class="fa fa-save me-2"></i> Save Changes';
    });
}

// Function to delete the selected ad
function deleteAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to delete.');
        return;
    }

    // Fancy Confirm dialog
    Notiflix.Confirm.show(
        // Title with FA icon
        '<i class="fa fa-exclamation-triangle text-danger me-2"></i> <span style="color:#dc3545;font-weight:bold;">Confirm Delete</span>',
        
        // Message with styled text
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#dc3545;">delete</b> this job ad?</span>',
        
        // OK button text with FA icon
        '<i class="fa fa-trash me-2"></i> Yes, Delete',
        
        // Cancel button text with FA icon
        '<i class="fa fa-times me-2"></i> Cancel',
        
        function okCb() {
            // Configure loader appearance
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px',
                cssAnimationDuration: 4000
            });

            // Show dotted circle loader
            Notiflix.Loading.circle('Deleting job ad...');

            const start = Date.now();
            const minDuration = 3000; // 3 seconds minimum

            fetch(`/jobboards/${ad.id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);
                return res.json();
            })
            .then(data => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.init({
                        timeout: 3000,
                        clickToClose: true,
                        pauseOnHover: true
                    });
                    Notiflix.Notify.success('Job ad deleted successfully!');
                    sessionStorage.removeItem('selectedAd');
                    window.location.href = '/admin/home';
                }, remaining);
            })
            .catch(err => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.failure(`Delete failed: ${err.message}`);
                }, remaining);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Delete cancelled.');
        },
        {
            // Extra styling for buttons
            okButtonBackground: '#dc3545',   // red delete button
            okButtonColor: '#fff',
            cancelButtonBackground: '#6c757d', // grey cancel button
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}


// Function to close other offcanvas elements
function closeAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to close.');
        return;
    }

    // Fancy confirm dialog
    Notiflix.Confirm.show(
        '<i class="fa fa-exclamation-circle text-warning me-2"></i> <span style="color:#ffc107;font-weight:bold;">Confirm Close</span>',
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#ffc107;">close</b> this job ad?</span>',
        '<i class="fa fa-check me-2"></i> Yes, Close',
        '<i class="fa fa-times me-2"></i> Cancel',
        function okCb() {
            // Show loader
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px'
            });
            Notiflix.Loading.circle('Closing job ad...');

            fetch(`/jobboards/${ad.id}/close`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);  
                return res.json();
            })
            .then(data => {
                Notiflix.Loading.remove();
                Notiflix.Notify.init({
                    timeout: 3000,
                    clickToClose: true,
                    pauseOnHover: true
                });
                Notiflix.Notify.success('Job ad closed successfully!');
                // Optionally redirect
                window.location.href = '/admin/home';
            })
            .catch(err => {
                Notiflix.Loading.remove();
                Notiflix.Notify.failure(`Close failed: ${err.message}`);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Close cancelled.');
        },
        {
            okButtonBackground: '#ffc107',   // yellow close button
            okButtonColor: '#000',
            cancelButtonBackground: '#6c757d',
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}



function cForceCloseOffcanvas(id) {
    const el = document.getElementById(id);
    if (!el) return;

    // Get existing instance OR create one if missing
    let instance = bootstrap.Offcanvas.getInstance(el);
    if (!instance) {
        instance = new bootstrap.Offcanvas(el);
    }

    instance.hide();

    // Remove leftover backdrop if Bootstrap bug leaves it behind
    document.querySelectorAll('.offcanvas-backdrop').forEach(b => b.remove());
}

function cCloseOtherOffcanvas() {
    // Close Ad Details offcanvas if open
    const openadDetailsCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('openadDetailsCanvase'));
      if (openadDetailsCanvas) openadDetailsCanvas.hide();

    // Close Active Jobs offcanvas if open
    const jobOffcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('jobOffcanvas-active'));
  
    if (jobOffcanvas) jobOffcanvas.hide();
}


</script>
