@extends('layouts.app')

@section('content')
<style>
    /* body {
        background: linear-gradient(135deg, rgb(247, 46, 140), #280415);
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        font-family: 'Inter', sans-serif;
    } */

    body {
    /* background: linear-gradient(135deg, rgb(247, 46, 140), #280415); */
    min-height: 100vh;
    font-family: 'Inter', sans-serif;
    overflow-x: hidden;
}

.login-wrapper {
     /* background: linear-gradient(135deg, rgb(247, 46, 140), #280415); */
    min-height: calc(100vh - 140px); /* leaves space for navbar */
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 40px;
}
 

    /* Floating blurred circles */
    .bg-bubble {
        position: absolute;
        border-radius: 50%;
        filter: blur(80px);
        opacity: 0.45;
        animation: float 12s infinite ease-in-out;
    }
    /* .bubble1 { width: 300px; height: 300px; background: #f661ac; top: -60px; left: -40px; }
    .bubble2 { width: 260px; height: 260px; background: #7a0b3f; bottom: -40px; right: -20px; animation-delay: 3s; } */

    @keyframes float {
        0% { transform: translateY(0px); }
        50% { transform: translateY(40px); }
        100% { transform: translateY(0px); }
    }

    .login-card {
        width: 420px;
        padding: 40px 35px;
        border-radius: 18px;
        backdrop-filter: blur(18px);
        background: rgba(255,255,255,0.12);
        border: 1px solid rgba(255,255,255,0.25);
        box-shadow: 0 15px 40px rgba(0,0,0,0.25);
        color: #fff;
        animation: fadeIn 0.6s ease;
           background: linear-gradient(135deg, rgb(247, 46, 140), #710537);
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .login-title {
        font-size: 20px;
        font-weight: 700;
        text-align: center;
        margin-bottom: 25px;
        letter-spacing: 0.5px;
    }

    .form-label {
        font-weight: 600;
        color: #fff;
    }

    .form-control {
        background: rgba(255,255,255,0.15);
        border: 1px solid rgba(255,255,255,0.25);
        color: #fff;
        border-radius: 10px;
        padding: 12px;
        transition: 0.25s ease;
    }

    .form-control:focus {
        background: rgba(216, 49, 116, 0.25);
        border-color: #ff4fa8;
        box-shadow: 0 0 0 0.2rem rgba(255,79,168,0.35);
        color: #fff;
    }

    .btn-login {
        width: 100%;
        padding: 12px;
        border-radius: 10px;
        background: rgb(113,16,62);
        border: none;
        font-weight: 600;
        font-size: 16px;
        transition: 0.25s ease;
        color: #fff;
    }

    .btn-login:hover {
        background: #c2186a;
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(194,24,106,0.4);
    }

    .forgot-link {
        color: #ffb7d9;
        text-decoration: none;
        font-size: 14px;
        transition: 0.2s ease;
    }

    .forgot-link:hover {
        text-decoration: underline;
        color: #fff;
    }

    .alert-danger {
        background: rgba(255, 0, 0, 0.25);
        border: 1px solid rgba(255, 0, 0, 0.4);
        color: #fff;
        border-radius: 10px;
        padding: 12px;
        margin-bottom: 15px;
    }

    .img-fluid {
        width: 30%;
        height: auto;
        display: block;
        margin: 0 auto;
    }


</style>

<div class="bg-bubble bubble1"></div>
<div class="bg-bubble bubble2"></div>

<div class="login-wrapper">
<div class="login-card">

    <img class="img-fluid" src="/assets/images/logo.png">

    {{-- <div class="login-title">Welcome Back Our Esteemed Customer</div> --}}

    {{-- Error Message --}}
    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}

            @if (session('show_login'))
                <br><br>
                <a href="{{ route('login') }}" class="btn-login">
                    Login
                </a>
            @endif
        </div>
    @endif

    <form method="POST" action="{{ route('login') }}">
        @csrf

        {{-- Email --}}
        <div class="mb-3">
            <label class="form-label">Email Address</label>
            <input id="email" type="email"
                   class="form-control @error('email') is-invalid @enderror"
                   name="email" value="{{ old('email') }}" required autofocus>

            @error('email')
                <span class="invalid-feedback" style="color:#ffb7d9;"><strong>{{ $message }}</strong></span>
            @enderror
        </div>

        {{-- Password --}}
        <div class="mb-3">
            <label class="form-label">Password</label>
            <input id="password" type="password"
                   class="form-control @error('password') is-invalid @enderror"
                   name="password" required>

            @error('password')
                <span class="invalid-feedback" style="color:#ffb7d9;"><strong>{{ $message }}</strong></span>
            @enderror
        </div>

        {{-- Remember Me --}}
        <div class="mb-3 form-check">
            <input class="form-check-input" type="checkbox" name="remember"
                   id="remember" {{ old('remember') ? 'checked' : '' }}>
            <label class="form-check-label" for="remember" style="color:#fff;">
                Remember Me
            </label>
        </div>

        {{-- Submit --}}
<button type="submit" class="btn-login" id="loginBtn">
    Login
</button>



        {{-- Forgot Password --}}
        @if (Route::has('password.request'))
            <div class="text-center mt-3">
                <a class="forgot-link" href="{{ route('password.request') }}">
                    Forgot Your Password?
                </a>
            </div>
        @endif
    </form>
    <div id="progressDialog" style="
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.45);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
">
    {{-- <div style="
        background: rgba(255,255,255,0.12);
        backdrop-filter: blur(10px);
        padding: 18px 24px;
        border-radius: 12px;
        text-align: center;
        color: #fff;
        border: 1px solid rgba(255,255,255,0.2);
        width: 220px;
    ">
        <div class="spinner-border text-light" style="width: 1.8rem; height: 1.8rem;"></div>
        <div style="margin-top: 10px; font-size: 14px; font-weight: 500;">
            Validating your credentials....
        </div>
    </div> --}}
</div>


</div>
</div>

<script>
    const form = document.querySelector('form');
    const btn = document.getElementById('loginBtn');
    const dialog = document.getElementById('progressDialog');

    form.addEventListener('submit', function () {
        // Show progress dialog
        dialog.style.display = "flex";

        // Update button
        btn.disabled = true;
        btn.innerHTML = `
            <div class="spinner-border spinner-border-sm" role="status"></div>
            Logging you in...
        `;
    });
</script>


@endsection

