@extends('layouts.admin.adminapp')
@include('components.offcanvas')
<meta name="csrf-token" content="{{ csrf_token() }}">

@section('content')
<style>
  .swp-form { max-width: 900px; margin: 0 auto; font-family: 'Segoe UI', sans-serif; }
  .swp-row { display: flex; border-bottom: 2px solid #eee; margin-bottom: 20px; }
  .swp-tab { flex: 1; text-align: center; padding: 14px; cursor: pointer; font-weight: 600; color: #444; transition: .2s; }
  .swp-tab.active { color: #fff; background-color: #71103e; border-radius: 6px 6px 0 0; }
  .swp-section { display: none; border: 1px solid #e5e7eb; border-radius: 0 0 10px 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.06); }
  .swp-section.active { display: block; }
  .swp-checkbox { display: block; margin-bottom: 10px; font-size: 15px; color: #444; }
  .btn-primary { background-color: #71103e; border: none; padding: 12px 24px; font-weight: 600; border-radius: 6px; }
  .btn-primary:hover { background-color: #8c1a4f; }
</style>

<div class="swp-form">
  <form>
    @csrf

    <hr class="my-4">

    <div id="customQuestionsList"></div>

    <h3 class="mb-3">Select questions to ask candidates</h3>
    <p class="mb-4">Click a category to expand and tick the questions you want applicants to answer:</p>

    {{-- <div class="swp-row">
      <div class="swp-tab active" data-target="working-rights">Working Rights</div>
      <div class="swp-tab" data-target="qualifications">Qualifications</div>
      <div class="swp-tab" data-target="first-aid">First Aid & CPR</div>
      <div class="swp-tab" data-target="driving">Driving</div>
      <div class="swp-tab" data-target="checks">Checks</div>
      <div class="swp-tab" data-target="experience">Experience</div>
      <div class="swp-tab" data-target="employment">Employment & Salary</div>
    </div> --}}

    <div class="swp-row">
    @foreach($questions as $category => $items)
        <div class="swp-tab {{ $loop->first ? 'active' : '' }}" data-target="cat-{{ $loop->index }}">
            {{ ucfirst(str_replace('_', ' ', $category)) }}
        </div>
    @endforeach
</div>

@foreach($questions as $category => $items)
    <div id="cat-{{ $loop->index }}" class="swp-section {{ $loop->first ? 'active' : '' }}">
        @foreach($items as $q)
            <label class="swp-checkbox">
                <input type="checkbox" name="questions[]" value="{{ $q->id }}">
                {{ $q->label }}
            </label>
        @endforeach
    </div>
@endforeach

<div id="customQuestionsList"></div>


    <button type="button" class="btn btn-primary" id="saveBtn">Save Ad & Checkout</button>


    
    <h4 class="mb-3">Add a Custom Question</h4>

    <div class="mb-3">
        <label class="form-label fw-bold">Question Label</label>
        <input type="text" id="newQuestionLabel" class="form-control" placeholder="e.g. Are you willing to work weekends?">
    </div>

    <div class="mb-3">
        <label class="form-label fw-bold">Question Type</label>
        <select id="newQuestionType" class="form-select">
            <option value="boolean">Yes / No</option>
            <option value="text">Short Text</option>
            <option value="number">Number</option>
            <option value="select">Dropdown</option>
        </select>
    </div>

    <div class="mb-3" id="newQuestionOptionsWrapper" style="display:none;">
        <label class="form-label fw-bold">Dropdown Options (comma separated)</label>
        <input type="text" id="newQuestionOptions" class="form-control" placeholder="Option1, Option2, Option3">
    </div>

    <button type="button" class="btn btn-secondary mb-4" id="addQuestionBtn">+ Add Question</button>


  </form>
</div>

<script>

// -------------------------
// TAB SWITCHING
// -------------------------
document.querySelectorAll('.swp-tab').forEach(tab => {
    tab.addEventListener('click', () => {
        document.querySelectorAll('.swp-tab').forEach(t => t.classList.remove('active'));
        document.querySelectorAll('.swp-section').forEach(s => s.classList.remove('active'));

        tab.classList.add('active');
        document.getElementById(tab.dataset.target).classList.add('active');
    });
});


// -------------------------
// SHOW/HIDE OPTIONS FOR SELECT TYPE
// -------------------------
document.getElementById('newQuestionType').addEventListener('change', function () {
    document.getElementById('newQuestionOptionsWrapper').style.display =
        this.value === 'select' ? 'block' : 'none';
});


// -------------------------
// ADD CUSTOM QUESTION
// -------------------------
document.getElementById('addQuestionBtn').addEventListener('click', async () => {
    const label = document.getElementById('newQuestionLabel').value.trim();
    const type = document.getElementById('newQuestionType').value;
    const options = document.getElementById('newQuestionOptions').value.trim();

    if (!label) {
        Notiflix.Notify.failure("Please enter a question label.");
        return;
    }

    const payload = {
        label,
        type,
        options: type === 'select' ? options.split(',').map(o => o.trim()) : null
    };

    const res = await fetch('/questions', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify(payload)
    });

    const data = await res.json();

    if (!res.ok) {
        Notiflix.Notify.failure("Failed to save question.");
        return;
    }

    Notiflix.Notify.success("Question added!");

    // Add checkbox dynamically
    const container = document.getElementById('customQuestionsList');
    container.insertAdjacentHTML('beforeend', `
        <label class="swp-checkbox">
            <input type="checkbox" name="questions[]" value="${data.id}">
            ${data.label}
        </label>
    `);

    // Clear fields
    document.getElementById('newQuestionLabel').value = "";
    document.getElementById('newQuestionOptions').value = "";
});


// -------------------------
// SAVE AD & REDIRECT
// -------------------------
// SAVE AD & REDIRECT
// -------------------------
document.getElementById('saveBtn').addEventListener('click', () => {

    let mergedData = {};
    try {
        const raw = sessionStorage.getItem('jobFormData');
        mergedData = raw ? JSON.parse(raw) : {};
    } catch (err) {
        mergedData = {};
    }

    const selectedQuestions = Array.from(
        document.querySelectorAll('input[name="questions[]"]:checked')
    ).map(cb => cb.value);

    mergedData.questions = selectedQuestions;

    sessionStorage.setItem('jobFormData', JSON.stringify(mergedData));

    Notiflix.Loading.circle('Redirecting to checkout...', {
        svgSize: '40px',
        fontSize: '14px'
    });

    setTimeout(() => {
        Notiflix.Loading.remove();
        const jobFormData = encodeURIComponent(sessionStorage.getItem('jobFormData'));
        window.location.href = `/checkout?jobFormData=${jobFormData}`;
    }, 2000);
});


</script>


@endsection
