<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AdsType;

class AdsTypeSeeder extends Seeder
{
    public function run(): void
    {
        $adTypes = [
            ['name' => 'basic',    'amount' => 100],
            ['name' => 'platinum', 'amount' => 200],
            ['name' => 'premium',  'amount' => 300],
        ];

        foreach ($adTypes as $type) {
            AdsType::updateOrCreate(
                ['name' => $type['name']],
                ['amount' => $type['amount']]
            );
        }
    }
}
