<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('transactions', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('job_board_id');
    $table->string('stripe_id');
    $table->string('status');
    $table->decimal('amount', 8, 2);
    $table->json('response');
    $table->timestamps();

    $table->foreign('job_board_id')->references('id')->on('job_boards')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
