<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('job_boards', function (Blueprint $table) {
    $table->id();

    // Foreign key to companies table
    $table->unsignedBigInteger('company_id');
    $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');

    // Fields
$table->string('ad_type');                // adType: "basic"
$table->string('category');               // category: "Support Workers"
$table->string('company');                // company: "xyz"
$table->text('description')->nullable();  // description: "xyz"
$table->string('job_title');              // jobTitle: "Support Worker"
$table->string('location');               // location: "s"
$table->string('workplace');              // workplace: "On-site"
$table->string('work_type');              // workType: "Full-time"
$table->string('pay_type');               // payType: "Hourly"
$table->decimal('pay_min', 10, 2)->nullable(); // payMin: "22"
$table->decimal('pay_max', 10, 2)->nullable(); // payMax: "22"
$table->boolean('pay_visibility');        // payVisibility: "show"
$table->text('summary')->nullable();      // summary: "xyz"
$table->string('logo')->nullable();       // logo: "savedWallpaper.jpg"
$table->text('overview')->nullable();     // overview: "xyz"
$table->string('social_media')->nullable(); // socialMedia: "xyz"
$table->string('video')->nullable();      // video: "savedWallpaper.jpg"
 
// Ad review status
$table->string('ad_rev_status')->default('notpaid'); // adRevStatus: "notpaid"
$table->string('status')->default('inactive'); // status: "active"
$table->date('expiry_date')->nullable(); // expiryDate: "2024-12-28"
$table->integer('ad_price')->nullable(); // adPrice: "99.00"
$table->string('ad_duration')->nullable(); // adDuration: "30"
$table->string('payment_intent_id')->nullable(); // paymentIntentId: "


    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jobboards');
    }
};
