<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
Schema::create('companies', function (Blueprint $table) {
    $table->id();
    $table->string('abn')->unique();
    $table->string('name')->nullable();
    $table->string('status')->nullable();
    $table->string('type')->nullable();
    $table->string('state')->nullable();
    $table->string('postcode')->nullable();

    // Temporary UUID placeholder (no FK)
    $table->uuid('c_uuid')->nullable();

    // Actual FK to users.id
    $table->unsignedBigInteger('user_id')->nullable();
    $table->foreign('user_id')
          ->references('id')->on('users')
          ->onDelete('cascade');

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
