<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        channels: __DIR__.'/../routes/channels.php',
        health: '/up',
    )
->withMiddleware(function (Middleware $middleware) {
    $middleware->alias([
        'user-access'      => \App\Http\Middleware\UserAccess::class,
        'company.created'  => \App\Http\Middleware\EnsureCompanyCreated::class,
    ]);
})

    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();