<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobBoard extends Model
{
    use HasFactory;
protected $fillable = [
    'company_id',
    'ad_type',
    'category',
    'company',
    'description',
    'job_title',
    'location',
    'workplace',
    'work_type',
    'pay_type',
    'pay_min',
    'pay_max',
    'pay_visibility',
    'summary',
    'logo',
    'overview',
    'social_media',
    'video',
    'ad_rev_status',
    'status',
    'expiry_date',
    'ad_price',
    'ad_duration',
    'payment_intent_id',
    'views'
];


protected $with = ['questions'];




   public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }



public function questions()
{
    return $this->belongsToMany(Question::class, 'job_question', 'job_board_id', 'question_id');
}



}

