<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

     protected $primaryKey = 'id';

    protected $fillable = [
       'abn',
        'name',
        'status',
        'type',
        'state',
        'postcode',
        'c_uuid',
        'user_id',
        'industry',
        'website',
        'description',
        'logo_url',
        'phone',
        'address',
    ];

 

    // Relationship: Company belongs to a User

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function jobBoards()
{
    return $this->hasMany(JobBoard::class, 'company_id');
}



}

