<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Application extends Model
{
    use HasFactory;

    protected $table = 'applications';

    protected $fillable = [
        'user_id',
        'job_board_id',
        'status',
        'resume_path',
        'cover_letter_path',
        'answers',
        'is_read',
    ];

    protected $casts = [
        'answers' => 'array', // auto-decode JSON into array
    ];

    /* Relationships */

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function job()
    {
        return $this->belongsTo(JobBoard::class, 'job_board_id');
    }
}
