<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Application;
use App\Models\JobBoard;
use Illuminate\Support\Facades\Auth;
use App\Models\User;


class ApplicationController extends Controller
{
    
    public function store(Request $request)
{
    $request->validate([
        'job_id'        => 'required|exists:job_boards,id',
        'resume_option' => 'required|string',
        'cover_option'  => 'required|string',
        'resume'        => 'nullable|file|mimes:pdf,doc,docx|max:5120',
        'cover_letter'  => 'nullable|file|mimes:pdf,doc,docx|max:5120',
        'answers'       => 'nullable|string'
    ]);

    $user = auth()->user();

    // Resume
    $resumePath = $user->resume_path;
    if ($request->resume_option === "upload" && $request->hasFile("resume")) {
        $resumePath = $request->file("resume")->store("resumes", "public");
        $user->update(['resume_path' => $resumePath]);
    }

    // Cover letter
    $coverPath = $user->cover_letter_path;
    if ($request->cover_option === "upload" && $request->hasFile("cover_letter")) {
        $coverPath = $request->file("cover_letter")->store("cover_letters", "public");
        $user->update(['cover_letter_path' => $coverPath]);
    }

    // Create application
    $application = Application::create([
        'user_id'           => $user->id,
        'job_board_id'      => $request->job_id,
        'status'            => 'Pending',
        'resume_path'       => $resumePath,
        'cover_letter_path' => $coverPath,
        'answers' => json_decode($request->answers, true),

    ]);


    $job = JobBoard::findOrFail($request->job_id);
$job->status = 'open';
$job->save();

    return response()->json(['success' => true]);
   
}

public function jobViewed($id)
{
    \DB::table('job_boards')
        ->where('id', $id)
        ->increment('views');

    return response()->json(['success' => true]);
}


// public function swApplications()
// {
//     $companyId = auth()->user()->company->id;

//     // dump($companyId);

//     $app = Application::whereHas('job', function ($q) use ($companyId) {
//         $q->where('company_id', $companyId);
//     })
//     ->with(['user', 'job'])
//     ->latest()
//     ->get();

//    return response()->json($app);
// }

public function swApplications()
{
    $companyId = auth()->user()->company->id;

    $applications = Application::whereHas('job', function ($q) use ($companyId) {
            $q->where('company_id', $companyId);
        })
        ->with(['user', 'job'])
        ->latest()
        ->get()
        ->map(function ($app) {

            return [
                'id' => $app->id,
                'status' => $app->status,
                'created_at' => $app->created_at,
                'user' => $app->user,
                'job' => $app->job,
                'job_category' => $app->job->category ?? null,   // FIXED
                'is_read' => $app->is_read,                     // NEW
            ];
        });

    return response()->json($applications);
}



// public function swApplicationDetails($id)
// {
//     $app = Application::with(['user', 'job'])
//         ->findOrFail($id);

//     return response()->json($app);
// }



// public function swApplicationDetails($id)
// {
//     $application = Application::with([
//         'user',
//         'job',
//         'job.questions' // <-- load questions for this job
//     ])->findOrFail($id);

//     return response()->json([
//         'id' => $application->id,
//         'status' => $application->status,
//         'created_at' => $application->created_at,
//         'user' => $application->user,
//         'job' => $application->job,
//         'questions' => $application->job->questions, // <-- send questions
//         'answers' => $application->answers,
//         'resume_path' => $application->resume_path,
//         'cover_letter_path' => $application->cover_letter_path,
//     ]);
// }

public function swApplicationDetails($id)
{
    $application = Application::with([
        'user',
        'job',
        'job.questions'
    ])->findOrFail($id);

    $answers = $application->answers ?? [];
    $mappedQA = [];

    foreach ($answers as $key => $value) {
        if (str_starts_with($key, 'question_')) {

            // Extract ID from "question_19"
            $questionId = (int) str_replace('question_', '', $key);

            // Find the question model from the job's questions
            $question = $application->job->questions
                ->firstWhere('id', $questionId);

            if ($question) {
                $mappedQA[] = [
                    'id' => $question->id,
                    'label' => $question->label,
                    'type' => $question->type,
                    'answer' => $value
                ];
            }
        }
    }

    return response()->json([
        'id' => $application->id,
        'status' => $application->status,
        'created_at' => $application->created_at,
        'user' => $application->user,
        'job' => $application->job,
        'questions' => $mappedQA, // <-- now mapped with labels + answers
        'resume_path' => $application->resume_path,
        'cover_letter_path' => $application->cover_letter_path,
           'is_read' => $application->is_read,
     
    ]);
}


public function reject($id)
{
    $app = Application::findOrFail($id);
    $app->status = 'Rejected';
    $app->save();

    return response()->json(['success' => true]);
}

public function shortlist($id)
{
    $app = Application::findOrFail($id);
    $app->status = 'Shortlisted';
    $app->save();

    return response()->json(['success' => true]);
}

public function pending($id)
{
    $app = Application::findOrFail($id);
    $app->status = 'Pending';
    $app->save();

    return response()->json(['success' => true]);
}

public function searchCandidates(Request $request)
{
    $role = $request->candidateRole;
    $location = $request->locationSearch;

    $query = Application::with(['user', 'job']);

    // Filter by job title/category
    if (!empty($role)) {
        $query->whereHas('job', function ($q) use ($role) {
            $q->where('category', $role);
        });
    }

    // Filter by job location (NOT user)
    if (!empty($location)) {
        $query->whereHas('job', function ($q) use ($location) {
            $q->where('location', 'LIKE', "%{$location}%");
        });
    }

    $results = $query->latest()->get();

    return response()->json([
        'success' => true,
        'results' => $results
    ]);
}


public function showProfile($id)
{
    $application = Application::with(['user', 'job'])->findOrFail($id);

    return response()->json([
        'success' => true,
        'application' => $application
    ]);
}
















public function getShortlistedRecipients()
{
    $companyId = auth()->user()->company->id;

    // Fetch applications for this company where status = shortlisted
    $shortlisted = Application::where('status', 'shortlisted')
        ->whereHas('job', function ($q) use ($companyId) {
            $q->where('company_id', $companyId);
        })
        ->with('user') // we only need the user relationship
        ->get()
        ->map(function ($app) {
            return [
                'id'    => $app->user->id,
                'name'  => $app->user->name,
                'email' => $app->user->email,
            ];
        })
        ->unique('email') // avoid duplicates if user applied to multiple jobs
        ->values();

    return response()->json($shortlisted);
}





}

